/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.entity;

import com.github.bonndan.blimpy.blimp.container.BlimpDataAccessor;
import com.github.bonndan.blimpy.blimp.container.BlimpMenu;
import com.github.bonndan.blimpy.blimp.entity.Balloon;
import com.github.bonndan.blimpy.blimp.entity.BlimpEntity;
import com.github.bonndan.blimpy.blimp.entity.engine.FueledEngine;
import com.github.bonndan.blimpy.blimp.entity.engine.SaveStateCallback;
import com.github.bonndan.blimpy.setup.ModSounds;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.kotlinforforge.neoforge.forge.vectorutil.v3d.Vec3iUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0093\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000f\u0018\u0000 \u0086\u00012\u00020\u00012\u00020\u0002:\u0002\u0086\u0001B-\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0016H\u0016J\b\u0010/\u001a\u00020&H\u0014J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000201J\b\u00103\u001a\u000201H\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020-H\u0016J\u001b\u00107\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010908H\u0016\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J \u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020B2\u0006\u0010*\u001a\u00020+2\u0006\u0010C\u001a\u000205H\u0014J\b\u0010D\u001a\u000205H\u0014J\u000e\u0010E\u001a\u0002012\u0006\u0010F\u001a\u00020-J\u0010\u0010G\u001a\u0002012\u0006\u0010H\u001a\u00020-H\u0016J\r\u0010I\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010JJ\u0015\u0010K\u001a\u0002012\b\u0010L\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010MJ\u0018\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u00020UH\u0002J\u0006\u0010V\u001a\u00020WJ\u0010\u0010X\u001a\u0002012\u0006\u0010Y\u001a\u00020ZH\u0014J\u0014\u0010[\u001a\u0002012\n\u0010\\\u001a\u0006\u0012\u0002\b\u00030]H\u0016J\u0010\u0010^\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0014J\u0010\u0010a\u001a\u0002012\u0006\u0010_\u001a\u00020`H\u0014J\u0010\u0010b\u001a\u0002012\u0006\u0010c\u001a\u00020dH\u0016J\b\u0010e\u001a\u000201H\u0016J\b\u0010f\u001a\u000201H\u0002J\b\u0010g\u001a\u000201H\u0002J\u000e\u0010h\u001a\u00020-2\u0006\u0010P\u001a\u00020QJ\u0018\u0010i\u001a\u0002012\u0006\u0010\u0005\u001a\u00020j2\u0006\u0010k\u001a\u00020lH\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010m\u001a\u00020?H\u0016J\b\u0010n\u001a\u00020oH\u0016J\u0010\u0010p\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0016J\u0018\u0010q\u001a\u0002012\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0016J\b\u0010r\u001a\u00020$H\u0016J\u0010\u0010s\u001a\u0002012\u0006\u0010#\u001a\u00020$H\u0016J\u000e\u0010t\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\b\u0010u\u001a\u000201H\u0016J\b\u0010v\u001a\u00020\u0016H\u0016J\u0010\u0010w\u001a\u00020\u001d2\u0006\u0010x\u001a\u00020\u0016H\u0016J\u0018\u0010y\u001a\u00020\u001d2\u0006\u0010x\u001a\u00020\u00162\u0006\u0010z\u001a\u00020\u0016H\u0016J\u0010\u0010{\u001a\u00020\u001d2\u0006\u0010x\u001a\u00020\u0016H\u0016J\u0018\u0010|\u001a\u0002012\u0006\u0010x\u001a\u00020\u00162\u0006\u0010}\u001a\u00020\u001dH\u0016J\b\u0010~\u001a\u000201H\u0016J\u0010\u0010\u007f\u001a\u00020-2\u0006\u0010P\u001a\u00020QH\u0016J\t\u0010\u0080\u0001\u001a\u000201H\u0016J'\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u00012\u0007\u0010\u0083\u0001\u001a\u00020\u00162\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010P\u001a\u00020QH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR4\u0010\u001b\u001a&\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d \u001e*\u0012\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0016\u0010 \u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0087\u0001"}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity;", "Lnet/minecraft/world/entity/vehicle/AbstractBoat;", "Lnet/minecraft/world/entity/vehicle/ContainerEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "dropItem", "Ljava/util/function/Supplier;", "Lnet/minecraft/world/item/Item;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Ljava/util/function/Supplier;)V", "balloon", "Lcom/github/bonndan/blimpy/blimp/entity/Balloon;", "saveStateCallback", "com/github/bonndan/blimpy/blimp/entity/BlimpEntity$saveStateCallback$1", "Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity$saveStateCallback$1;", "engine", "Lcom/github/bonndan/blimpy/blimp/entity/engine/FueledEngine;", "getEngine", "()Lcom/github/bonndan/blimpy/blimp/entity/engine/FueledEngine;", "thrustSoundCooldown", "", "getThrustSoundCooldown", "()I", "setThrustSoundCooldown", "(I)V", "itemStacks", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "Lnet/minecraft/core/NonNullList;", "lootTable", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/storage/loot/LootTable;", "lootTableSeed", "", "heightControl", "", "status", "Lnet/minecraft/world/entity/vehicle/AbstractBoat$Status;", "rideHeight", "dimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "getPaddleState", "", "side", "getDefaultGravity", "sink", "", "rise", "playThrustSound", "getGroundFriction", "", "isMultipartEntity", "getParts", "", "Lnet/neoforged/neoforge/entity/PartEntity;", "()[Lnet/neoforged/neoforge/entity/PartEntity;", "move", "type", "Lnet/minecraft/world/entity/MoverType;", "movement", "Lnet/minecraft/world/phys/Vec3;", "getPassengerAttachmentPoint", "entity", "Lnet/minecraft/world/entity/Entity;", "partialTick", "getSinglePassengerXOffset", "setEngineOn", "state", "onAboveBubbleCol", "downwards", "getColorId", "()Ljava/lang/Integer;", "setColorId", "color", "(Ljava/lang/Integer;)V", "interact", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "createMenuProvider", "Lnet/minecraft/world/MenuProvider;", "getDataAccessor", "Lcom/github/bonndan/blimpy/blimp/container/BlimpDataAccessor;", "defineSynchedData", "pBuilder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "onSyncedDataUpdated", "key", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "readAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "recreateFromPacket", "packet", "Lnet/minecraft/network/protocol/game/ClientboundAddEntityPacket;", "tick", "applyVerticalFriction", "deriveStatusFromPaddleSound", "isValid", "destroy", "Lnet/minecraft/server/level/ServerLevel;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "position", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "getContainerLootTable", "setContainerLootTable", "getContainerLootTableSeed", "setContainerLootTableSeed", "getItemStacks", "clearItemStacks", "getContainerSize", "getItem", "slot", "removeItem", "amount", "removeItemNoUpdate", "setItem", "stack", "setChanged", "stillValid", "clearContent", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "Companion", "blimpy"})
public final class BlimpEntity
extends AbstractBoat
implements ContainerEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Balloon balloon;
    @NotNull
    private final saveStateCallback.1 saveStateCallback;
    @NotNull
    private final FueledEngine engine;
    private int thrustSoundCooldown;
    private NonNullList<ItemStack> itemStacks;
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;
    private double heightControl;
    @NotNull
    private AbstractBoat.Status status;
    @NotNull
    private static final EntityDataAccessor<Integer> COLOR_ID;
    @NotNull
    private static final EntityDataAccessor<Boolean> ENGINE_IS_ON;
    @NotNull
    private static final EntityDataAccessor<Integer> REMAINING_BURN_TIME;
    private static final double PASSENGER_Y_OFFSET = 0.1;
    private static final float PASSENGER_X_OFFSET = 0.2f;
    @NotNull
    private static final String COLOR = "Color";
    private static final int MAX_HEIGHT = 350;
    private static final int ENGINE_SLOT = 0;
    public static final int CONTAINER_SIZE = 9;

    public BlimpEntity(@NotNull EntityType<? extends AbstractBoat> entityType, @NotNull Level level, @NotNull Supplier<Item> dropItem) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter(dropItem, (String)"dropItem");
        super(entityType, level, dropItem);
        this.balloon = new Balloon(this);
        this.saveStateCallback = new SaveStateCallback(this){
            final /* synthetic */ BlimpEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public void saveState(boolean engineState, int remainingBurnTime) {
                BlimpEntity.access$getEntityData$p(this.this$0).set(BlimpEntity.access$getENGINE_IS_ON$cp(), (Object)engineState);
                BlimpEntity.access$getEntityData$p(this.this$0).set(BlimpEntity.access$getREMAINING_BURN_TIME$cp(), (Object)remainingBurnTime);
            }
        };
        SaveStateCallback saveStateCallback2 = this.saveStateCallback;
        FuelValues fuelValues = this.level().fuelValues();
        Intrinsics.checkNotNullExpressionValue((Object)fuelValues, (String)"fuelValues(...)");
        this.engine = new FueledEngine(saveStateCallback2, fuelValues);
        this.itemStacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        this.status = AbstractBoat.Status.IN_AIR;
    }

    @NotNull
    public final FueledEngine getEngine() {
        return this.engine;
    }

    public final int getThrustSoundCooldown() {
        return this.thrustSoundCooldown;
    }

    public final void setThrustSoundCooldown(int n) {
        this.thrustSoundCooldown = n;
    }

    protected double rideHeight(@NotNull EntityDimensions dimensions) {
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        return dimensions.height() / 3.0f;
    }

    public boolean getPaddleState(int side) {
        return false;
    }

    protected double getDefaultGravity() {
        if (this.getY() >= 350.0) {
            this.heightControl = super.getDefaultGravity();
        }
        if (this.status == AbstractBoat.Status.ON_LAND && this.heightControl > 0.0) {
            this.heightControl = 0.0;
        }
        if (this.status == AbstractBoat.Status.IN_WATER && this.heightControl >= 0.0 && this.engine.isLit()) {
            this.heightControl = -0.05;
            this.setDeltaMovement(this.getDeltaMovement().add(new Vec3(0.0, 0.01, 0.0)));
        }
        if (this.engine.isLit()) {
            return 0.0 + this.heightControl;
        }
        return super.getDefaultGravity();
    }

    public final void sink() {
        this.heightControl += super.getDefaultGravity() * 0.1;
        this.playThrustSound();
    }

    public final void rise() {
        if (!this.engine.isLit()) {
            return;
        }
        this.heightControl -= super.getDefaultGravity() * 0.1;
        this.playThrustSound();
    }

    private final void playThrustSound() {
        Level level = this.level();
        if (level instanceof ClientLevel && this.thrustSoundCooldown == 0) {
            ((ClientLevel)level).playLocalSound((Entity)this, ModSounds.INSTANCE.getHISS().get(), this.getSoundSource(), 0.8f, 1.0f);
            this.thrustSoundCooldown = 4;
        }
    }

    public float getGroundFriction() {
        return Math.min(0.9f, super.getGroundFriction());
    }

    public boolean isMultipartEntity() {
        return true;
    }

    @NotNull
    public PartEntity<?>[] getParts() {
        Balloon[] balloonArray = new Balloon[]{this.balloon};
        return balloonArray;
    }

    public void move(@NotNull MoverType type, @NotNull Vec3 movement) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)movement, (String)"movement");
        this.balloon.move(type, movement);
        if (this.balloon.horizontalCollision || this.balloon.verticalCollision) {
            return;
        }
        super.move(type, movement);
    }

    @NotNull
    protected Vec3 getPassengerAttachmentPoint(@NotNull Entity entity, @NotNull EntityDimensions dimensions, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        Vec3 vec3 = super.getPassengerAttachmentPoint(entity, dimensions, partialTick).add(new Vec3(0.0, 0.1, 0.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    protected float getSinglePassengerXOffset() {
        return 0.2f;
    }

    public final void setEngineOn(boolean state) {
        this.engine.setEngineOn(state);
    }

    public void onAboveBubbleCol(boolean downwards) {
    }

    @Nullable
    public final Integer getColorId() {
        Integer color;
        Integer n = color = (Integer)this.getEntityData().get(COLOR_ID);
        return n != null && n == 0 ? null : color;
    }

    public final void setColorId(@Nullable Integer color) {
        Integer color2 = color;
        if (color2 == null) {
            color2 = 0;
        }
        this.getEntityData().set(COLOR_ID, (Object)color2);
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        DyeColor color = DyeColor.getColor((ItemStack)player.getItemInHand(hand));
        if (color != null) {
            if (!this.level().isClientSide) {
                this.setColorId(color.getId());
            }
            InteractionResult.Success success = InteractionResult.SUCCESS;
            Intrinsics.checkNotNullExpressionValue((Object)success, (String)"SUCCESS");
            return (InteractionResult)success;
        }
        if (!this.level().isClientSide && player.isSecondaryUseActive()) {
            player.openMenu(this.createMenuProvider(), this.getDataAccessor()::write);
            InteractionResult.Success success = InteractionResult.CONSUME;
            Intrinsics.checkNotNullExpressionValue((Object)success, (String)"CONSUME");
            return (InteractionResult)success;
        }
        InteractionResult ret = super.interact(player, hand);
        if (ret.consumesAction()) {
            Intrinsics.checkNotNull((Object)ret);
            return ret;
        }
        Intrinsics.checkNotNull((Object)ret);
        return ret;
    }

    private final MenuProvider createMenuProvider() {
        return new MenuProvider(this){
            final /* synthetic */ BlimpEntity this$0;
            {
                this.this$0 = $receiver;
            }

            public Component getDisplayName() {
                MutableComponent mutableComponent = Component.translatable((String)"entity.blimpy.blimp");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                return (Component)mutableComponent;
            }

            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player player) {
                Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return new BlimpMenu(i, this.this$0.level(), this.this$0.getDataAccessor(), playerInventory, player);
            }
        };
    }

    @NotNull
    public final BlimpDataAccessor getDataAccessor() {
        BlimpDataAccessor accessor = new BlimpDataAccessor.Builder().withId(this.getId()).withOn(() -> BlimpEntity.getDataAccessor$lambda$0(this)).withLit(() -> BlimpEntity.getDataAccessor$lambda$1(this)).withBurnProgressPct(() -> BlimpEntity.getDataAccessor$lambda$2(this)).build();
        return accessor;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder pBuilder) {
        Intrinsics.checkNotNullParameter((Object)pBuilder, (String)"pBuilder");
        super.defineSynchedData(pBuilder);
        pBuilder.define(ENGINE_IS_ON, (Object)false);
        pBuilder.define(REMAINING_BURN_TIME, (Object)0);
        pBuilder.define(COLOR_ID, (Object)0);
    }

    public void onSyncedDataUpdated(@NotNull EntityDataAccessor<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        super.onSyncedDataUpdated(key);
        if (!this.level().isClientSide) {
            return;
        }
        if (Intrinsics.areEqual(key, COLOR_ID)) {
            this.setColorId((Integer)this.entityData.get(COLOR_ID));
        }
        if (Intrinsics.areEqual(ENGINE_IS_ON, key)) {
            Object object = this.entityData.get(ENGINE_IS_ON);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.setEngineOn((Boolean)object);
        }
        if (Intrinsics.areEqual(REMAINING_BURN_TIME, key)) {
            Object object = this.entityData.get(REMAINING_BURN_TIME);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.engine.setRemainingBurnTime(((Number)object).intValue());
        }
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        RegistryAccess registryAccess = this.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        this.engine.readAdditionalSaveData(compound, registryAccess);
        if (compound.contains(COLOR, 3)) {
            this.setColorId(compound.getInt(COLOR));
        }
        this.readChestVehicleSaveData(compound, (HolderLookup.Provider)this.registryAccess());
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        RegistryAccess registryAccess = this.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        this.engine.addAdditionalSaveData(compound, registryAccess);
        Integer color = this.getColorId();
        if (color != null) {
            compound.putInt(COLOR, color.intValue());
        }
        this.addChestVehicleSaveData(compound, (HolderLookup.Provider)this.registryAccess());
    }

    public void recreateFromPacket(@NotNull ClientboundAddEntityPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        super.recreateFromPacket(packet);
        this.balloon.setId(packet.getId());
    }

    public void tick() {
        super.tick();
        this.deriveStatusFromPaddleSound();
        this.balloon.updatePosition((Entity)this);
        this.engine.tickFuel();
        if (this.engine.isLit()) {
            Level level = this.level();
            BlockPos blockPos = this.getOnPos().above().above();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
            this.engine.makeEmissions(level, Vec3iUtilKt.toVec3((Vec3i)((Vec3i)blockPos)), new Vec3(this.getX(), this.getY(), this.getZ()), new Vec3(this.xOld, this.yOld, this.zOld));
        }
        this.applyVerticalFriction();
        if (this.thrustSoundCooldown > 0) {
            int n = this.thrustSoundCooldown;
            this.thrustSoundCooldown = n + -1;
        }
    }

    private final void applyVerticalFriction() {
        if (Math.abs(this.heightControl) > 0.0) {
            this.heightControl = Math.abs(this.heightControl) < 0.01 ? 0.0 : (this.heightControl *= 0.5);
        }
        double dy = this.getDeltaMovement().y * 0.95;
        this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, dy, this.getDeltaMovement().z));
    }

    private final void deriveStatusFromPaddleSound() {
        SoundEvent sound = this.getPaddleSound();
        SoundEvent soundEvent = sound;
        this.status = Intrinsics.areEqual((Object)soundEvent, (Object)SoundEvents.BOAT_PADDLE_WATER) ? AbstractBoat.Status.IN_WATER : (Intrinsics.areEqual((Object)soundEvent, (Object)SoundEvents.BOAT_PADDLE_LAND) ? AbstractBoat.Status.ON_LAND : AbstractBoat.Status.IN_AIR);
    }

    public final boolean isValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return !this.isRemoved() && player.canInteractWithEntity(this.getBoundingBox(), 4.0);
    }

    protected void destroy(@NotNull ServerLevel level, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        this.destroy(level, this.getDropItem());
        this.chestVehicleDestroyed(damageSource, level, (Entity)this);
        this.spawnAtLocation(level, this.engine.getStackInSlot(0));
    }

    @NotNull
    public Level level() {
        Level level = super.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return level;
    }

    @NotNull
    public Vec3 position() {
        Vec3 vec3 = super.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        return vec3;
    }

    @NotNull
    public Component getDisplayName() {
        Component component = super.getDisplayName();
        Intrinsics.checkNotNull((Object)component);
        return component;
    }

    @Nullable
    public ResourceKey<LootTable> getContainerLootTable() {
        return this.lootTable;
    }

    public void setContainerLootTable(@Nullable ResourceKey<LootTable> lootTable) {
        this.lootTable = lootTable;
    }

    public long getContainerLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setContainerLootTableSeed(long lootTableSeed) {
        this.lootTableSeed = lootTableSeed;
    }

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        NonNullList<ItemStack> nonNullList = this.itemStacks;
        Intrinsics.checkNotNullExpressionValue(nonNullList, (String)"itemStacks");
        return nonNullList;
    }

    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public int getContainerSize() {
        return 9;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot == 0) {
            ItemStack itemStack = this.engine.getStackInSlot(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
            return itemStack;
        }
        Object object = this.itemStacks.get(slot - 1);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        if (slot == 0) {
            ItemStack itemStack = this.engine.extractItem(slot, amount, false);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"extractItem(...)");
            return itemStack;
        }
        ItemStack itemStack = this.removeChestVehicleItem(slot - 1, amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeChestVehicleItem(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        if (slot == 0) {
            ItemStack itemStack = this.engine.getStackInSlot(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
            return itemStack;
        }
        ItemStack itemStack = this.removeChestVehicleItemNoUpdate(slot - 1);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"removeChestVehicleItemNoUpdate(...)");
        return itemStack;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (slot == 0) {
            this.engine.setStackInSlot(slot, stack);
        }
        this.itemStacks.set(slot - 1, (Object)stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.isChestVehicleStillValid(player);
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.createMenuProvider().createMenu(containerId, playerInventory, player);
    }

    private static final boolean getDataAccessor$lambda$0(BlimpEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.engine.isOn();
    }

    private static final boolean getDataAccessor$lambda$1(BlimpEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.engine.isLit();
    }

    private static final int getDataAccessor$lambda$2(BlimpEntity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.engine.getBurnProgressPct();
    }

    public static final /* synthetic */ SynchedEntityData access$getEntityData$p(BlimpEntity $this) {
        return $this.entityData;
    }

    public static final /* synthetic */ EntityDataAccessor access$getENGINE_IS_ON$cp() {
        return ENGINE_IS_ON;
    }

    public static final /* synthetic */ EntityDataAccessor access$getREMAINING_BURN_TIME$cp() {
        return REMAINING_BURN_TIME;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(BlimpEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        COLOR_ID = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(BlimpEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        ENGINE_IS_ON = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(BlimpEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        REMAINING_BURN_TIME = entityDataAccessor3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity$Companion;", "", "<init>", "()V", "COLOR_ID", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "ENGINE_IS_ON", "", "REMAINING_BURN_TIME", "PASSENGER_Y_OFFSET", "", "PASSENGER_X_OFFSET", "", "COLOR", "", "MAX_HEIGHT", "ENGINE_SLOT", "CONTAINER_SIZE", "blimpy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

