/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.entity.bombbay;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0004\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/bombbay/BombBay;", "", "<init>", "()V", "launchBomb", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickItem;", "Lnet/minecraft/world/entity/player/Player;", "blimpy"})
public final class BombBay {
    @NotNull
    public static final BombBay INSTANCE = new BombBay();

    private BombBay() {
    }

    public final void launchBomb(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!itemStack.is(Items.TNT) || itemStack == null || itemStack.isEmpty()) {
            return;
        }
        Level level = player.level();
        double x = player.getX();
        double y = player.getY() - 1.0;
        double z = player.getZ();
        PrimedTnt tnt = new PrimedTnt(level, x, y, z, (LivingEntity)player);
        level.addFreshEntity((Entity)tnt);
        level.gameEvent((Entity)player, (Holder)GameEvent.PRIME_FUSE, player.blockPosition());
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
            if (itemStack.isEmpty()) {
                player.getInventory().removeItem(itemStack);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public final boolean launchBomb(@NotNull PlayerInteractEvent.RightClickItem event, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack tnt = event.getItemStack();
        if (!tnt.is(Items.TNT) || tnt == null || tnt.isEmpty()) {
            return false;
        }
        Level level = event.getLevel();
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        return true;
    }
}

