/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.beam;

import com.github.bonndan.blimpy.setup.ForgeClientEventHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ2\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"Lcom/github/bonndan/blimpy/beam/RenderUtil;", "", "<init>", "()V", "computeFixedDistance", "Lnet/minecraft/world/phys/Vec3;", "target", "position", "scale", "", "renderBeam", "", "matrixStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "event", "Lnet/neoforged/neoforge/client/event/RenderLevelStageEvent;", "player", "Lnet/minecraft/world/entity/player/Player;", "color", "", "blimpy"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();

    private RenderUtil() {
    }

    @NotNull
    public final Vec3 computeFixedDistance(@NotNull Vec3 target, @NotNull Vec3 position, double scale) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Vec3 newTarget = target;
        newTarget = newTarget.add(0.0, 2.0, 0.0);
        Vec3 delta = position.vectorTo(newTarget);
        double dist = Math.min(5.0, delta.length());
        Vec3 vec3 = position.add(delta.normalize().scale(dist * scale));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    public final void renderBeam(@Nullable PoseStack matrixStack, @Nullable MultiBufferSource.BufferSource buffer, @NotNull RenderLevelStageEvent event, @NotNull Player player, int color) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BeaconRenderer.renderBeaconBeam((PoseStack)matrixStack, (MultiBufferSource)((MultiBufferSource)buffer), (ResourceLocation)ForgeClientEventHandler.INSTANCE.getBEAM_LOCATION(), (float)event.getPartialTick().getGameTimeDeltaTicks(), (float)1.0f, (long)player.level().getGameTime(), (int)(player.level().getMinY() + 1), (int)1024, (int)color, (float)0.1f, (float)0.2f);
    }
}

