/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.container;

import com.github.bonndan.blimpy.blimp.container.BlimpDataAccessor;
import com.github.bonndan.blimpy.blimp.entity.BlimpEntity;
import com.github.bonndan.blimpy.network.SetEnginePacket;
import com.github.bonndan.blimpy.network.VehiclePacketHandler;
import com.github.bonndan.blimpy.setup.ModMenuTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/github/bonndan/blimpy/blimp/container/BlimpMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "windowId", "", "world", "Lnet/minecraft/world/level/Level;", "data", "Lcom/github/bonndan/blimpy/blimp/container/BlimpDataAccessor;", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "<init>", "(ILnet/minecraft/world/level/Level;Lcom/github/bonndan/blimpy/blimp/container/BlimpDataAccessor;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/entity/player/Player;)V", "entity", "Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity;", "isLit", "", "()Z", "isOn", "setEngineState", "", "state", "getBurnProgress", "stillValid", "addSlotRange", "handler", "Lnet/neoforged/neoforge/items/IItemHandler;", "index", "x", "y", "amount", "dx", "quickMoveStack", "Lnet/minecraft/world/item/ItemStack;", "playerIn", "Companion", "blimpy"})
@SourceDebugExtension(value={"SMAP\nBlimpMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlimpMenu.kt\ncom/github/bonndan/blimpy/blimp/container/BlimpMenu\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class BlimpMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlimpDataAccessor data;
    @Nullable
    private final Player player;
    @Nullable
    private BlimpEntity entity;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    @NotNull
    private static final ResourceLocation EMPTY_ATLAS_LOC;

    /*
     * WARNING - void declaration
     */
    public BlimpMenu(int windowId, @NotNull Level world, @NotNull BlimpDataAccessor data, @NotNull Inventory playerInventory, @Nullable Player player) {
        BlimpEntity blimpEntity;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        super(ModMenuTypes.INSTANCE.getBLIMP_MENU().get(), windowId);
        this.data = data;
        this.player = player;
        BlimpMenu blimpMenu = this;
        Integer n = this.data.getEntityUUID();
        if (n != null) {
            void it;
            int n2 = ((Number)n).intValue();
            BlimpMenu blimpMenu2 = blimpMenu;
            boolean bl = false;
            blimpEntity = (BlimpEntity)world.getEntity((int)it);
            blimpMenu = blimpMenu2;
        } else {
            blimpEntity = null;
        }
        blimpMenu.entity = blimpEntity;
        this.addStandardInventorySlots((Container)playerInventory, 8, 84);
        BlimpEntity blimpEntity2 = this.entity;
        if (blimpEntity2 != null) {
            BlimpEntity it = blimpEntity2;
            boolean bl = false;
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)it.getEngine(), 0, 80, 24));
            BlimpEntity blimpEntity3 = this.entity;
            Intrinsics.checkNotNull((Object)((Object)blimpEntity3), (String)"null cannot be cast to non-null type net.minecraft.world.Container");
            this.addSlotRange((IItemHandler)new InvWrapper((Container)blimpEntity3), 1, 8, 48, 9, 18);
        }
        this.addDataSlots(this.data.getRawData());
    }

    public final boolean isLit() {
        return this.data.isLit();
    }

    public final boolean isOn() {
        return this.data.isOn();
    }

    public final void setEngineState(boolean state) {
        BlimpEntity blimpEntity = this.entity;
        Intrinsics.checkNotNull((Object)((Object)blimpEntity));
        VehiclePacketHandler.INSTANCE.send(new SetEnginePacket(blimpEntity.getId(), state));
    }

    public final int getBurnProgress() {
        return this.data.getBurnProgress();
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        BlimpEntity blimpEntity = this.entity;
        return blimpEntity != null ? blimpEntity.isValid(player) : false;
    }

    private final int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        int index2 = index;
        int x2 = x;
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index2, x2, y));
            x2 += dx;
            ++index2;
        }
        return index2;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Object object = this.slots.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Slot sourceSlot = (Slot)object;
        if (!sourceSlot.hasItem()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 46, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else if (index <= 45) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        } else {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(this.player, sourceStack);
        Intrinsics.checkNotNull((Object)copyOfSourceStack);
        return copyOfSourceStack;
    }

    static {
        ResourceLocation resourceLocation = InventoryMenu.BLOCK_ATLAS;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"BLOCK_ATLAS");
        EMPTY_ATLAS_LOC = resourceLocation;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/github/bonndan/blimpy/blimp/container/BlimpMenu$Companion;", "", "<init>", "()V", "HOTBAR_SLOT_COUNT", "", "PLAYER_INVENTORY_ROW_COUNT", "PLAYER_INVENTORY_COLUMN_COUNT", "PLAYER_INVENTORY_SLOT_COUNT", "VANILLA_SLOT_COUNT", "VANILLA_FIRST_SLOT_INDEX", "TE_INVENTORY_FIRST_SLOT_INDEX", "EMPTY_ATLAS_LOC", "Lnet/minecraft/resources/ResourceLocation;", "getEMPTY_ATLAS_LOC", "()Lnet/minecraft/resources/ResourceLocation;", "blimpy"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getEMPTY_ATLAS_LOC() {
            return EMPTY_ATLAS_LOC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

