/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.entity;

import com.github.bonndan.blimpy.blimp.entity.BlimpEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\tH\u0016J \u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$H\u0016J\b\u0010'\u001a\u00020\u000eH\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016\u00a8\u0006."}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/Balloon;", "Lnet/neoforged/neoforge/entity/PartEntity;", "Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity;", "parent", "<init>", "(Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity;)V", "updatePosition", "", "parentEntity", "Lnet/minecraft/world/entity/Entity;", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "hurtServer", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "readAdditionalSaveData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "getDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "shouldBeSaved", "getPickResult", "Lnet/minecraft/world/item/ItemStack;", "is", "entity", "setPos", "x", "", "y", "z", "isPickable", "interact", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "blimpy"})
public final class Balloon
extends PartEntity<BlimpEntity> {
    public Balloon(@NotNull BlimpEntity parent) {
        Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
        super((Entity)parent);
        this.refreshDimensions();
    }

    public final void updatePosition(@NotNull Entity parentEntity) {
        Intrinsics.checkNotNullParameter((Object)parentEntity, (String)"parentEntity");
        double oldX = this.getX();
        double oldY = this.getY();
        double oldZ = this.getZ();
        double x = parentEntity.getX();
        double z = parentEntity.getZ();
        double y = parentEntity.getY() + 1.6;
        this.setPos(x, y, z);
        this.zOld = oldZ;
        this.zo = oldZ;
        this.xOld = oldX;
        this.xo = oldX;
        this.yOld = oldY;
        this.yo = oldY;
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    public boolean hurtServer(@NotNull ServerLevel level, @NotNull DamageSource damageSource, float amount) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        return ((BlimpEntity)this.getParent()).hurtServer(level, damageSource, amount);
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        EntityDimensions entityDimensions = ((BlimpEntity)this.getParent()).getDimensions(pose);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"getDimensions(...)");
        return entityDimensions;
    }

    public boolean shouldBeSaved() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return ((BlimpEntity)this.getParent()).getPickResult();
    }

    public boolean is(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return Intrinsics.areEqual((Object)((Object)this), (Object)entity) || Intrinsics.areEqual((Object)this.getParent(), (Object)entity);
    }

    public void setPos(double x, double y, double z) {
        super.setPos(x, y, z);
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    @NotNull
    public InteractionResult interact(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        return ((BlimpEntity)this.getParent()).interact(player, hand);
    }
}

