/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.entity.engine;

import com.github.bonndan.blimpy.blimp.entity.engine.Emissions;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/bonndan/blimpy/blimp/entity/engine/SmokeGenerator;", "Lcom/github/bonndan/blimpy/blimp/entity/engine/Emissions;", "<init>", "()V", "smokeChance", "", "makeEmissions", "", "level", "Lnet/minecraft/world/level/Level;", "emitterPos", "Lnet/minecraft/world/phys/Vec3;", "entityPos", "oldEntityPos", "makeParticles", "pos", "currentPos", "oldPos", "blimpy"})
public final class SmokeGenerator
implements Emissions {
    @NotNull
    public static final SmokeGenerator INSTANCE = new SmokeGenerator();
    private static final double smokeChance = 0.3;

    private SmokeGenerator() {
    }

    @Override
    public void makeEmissions(@NotNull Level level, @NotNull Vec3 emitterPos, @NotNull Vec3 entityPos, @NotNull Vec3 oldEntityPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)emitterPos, (String)"emitterPos");
        Intrinsics.checkNotNullParameter((Object)entityPos, (String)"entityPos");
        Intrinsics.checkNotNullParameter((Object)oldEntityPos, (String)"oldEntityPos");
        RandomSource randomSource = level.random;
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
        RandomSource random = randomSource;
        if ((double)random.nextFloat() < 0.3) {
            int n = random.nextInt(2) + 2;
            for (int i = 0; i < n; ++i) {
                this.makeParticles(level, emitterPos, entityPos, oldEntityPos);
            }
        }
    }

    private final void makeParticles(Level level, Vec3 pos, Vec3 currentPos, Vec3 oldPos) {
        SimpleParticleType simpleParticleType;
        RandomSource randomSource = level.getRandom();
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"getRandom(...)");
        RandomSource random = randomSource;
        Supplier<Boolean> h = () -> SmokeGenerator.makeParticles$lambda$0(random);
        double dx = (currentPos.x - oldPos.x) / 12.0;
        double dy = (currentPos.y - oldPos.y) / 12.0;
        double dz = (currentPos.z - oldPos.z) / 12.0;
        double xDrift = (double)(h.get() != false ? 1 : -1) * random.nextDouble() * (double)2;
        double zDrift = (double)(h.get() != false ? 1 : -1) * random.nextDouble() * (double)2;
        if (random.nextBoolean()) {
            SimpleParticleType simpleParticleType2 = ParticleTypes.CAMPFIRE_SIGNAL_SMOKE;
            simpleParticleType = simpleParticleType2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType2, (String)"CAMPFIRE_SIGNAL_SMOKE");
        } else {
            SimpleParticleType simpleParticleType3 = ParticleTypes.CAMPFIRE_COSY_SMOKE;
            simpleParticleType = simpleParticleType3;
            Intrinsics.checkNotNullExpressionValue((Object)simpleParticleType3, (String)"CAMPFIRE_COSY_SMOKE");
        }
        SimpleParticleType particleType = simpleParticleType;
        level.addAlwaysVisibleParticle((ParticleOptions)particleType, true, pos.x + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), pos.y + random.nextDouble() + random.nextDouble(), pos.z + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.007 * xDrift + dx, 0.05 + dy, 0.007 * zDrift + dz);
    }

    private static final Boolean makeParticles$lambda$0(RandomSource $random) {
        Intrinsics.checkNotNullParameter((Object)$random, (String)"$random");
        return $random.nextDouble() < 0.5;
    }
}

