/*
 * Decompiled with CFR 0.152.
 */
package com.github.bonndan.blimpy.blimp.model;

import com.github.bonndan.blimpy.blimp.entity.BlimpEntity;
import com.github.bonndan.blimpy.blimp.model.BlimpBodyModel;
import com.github.bonndan.blimpy.blimp.model.BlimpRenderState;
import com.github.bonndan.blimpy.blimp.model.BlimpTintModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J>\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016J \u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/bonndan/blimpy/blimp/model/BlimpBoatRenderer;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "Lcom/github/bonndan/blimpy/blimp/entity/BlimpEntity;", "Lcom/github/bonndan/blimpy/blimp/model/BlimpRenderState;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "blockRenderer", "Lnet/minecraft/client/renderer/block/BlockRenderDispatcher;", "model", "Lnet/minecraft/client/model/EntityModel;", "colorModel", "texture", "Lnet/minecraft/resources/ResourceLocation;", "render", "", "renderState", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "renderColorModel", "buffer", "colorTexture", "createRenderState", "extractRenderState", "entity", "reusedState", "partialTick", "", "blimpy"})
public final class BlimpBoatRenderer
extends EntityRenderer<BlimpEntity, BlimpRenderState> {
    @NotNull
    private final BlockRenderDispatcher blockRenderer;
    @NotNull
    private final EntityModel<BlimpRenderState> model;
    @NotNull
    private final EntityModel<BlimpRenderState> colorModel;
    @NotNull
    private final ResourceLocation texture;

    public BlimpBoatRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"blimpy", (String)"textures/entity/blimp_texture.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.texture = resourceLocation;
        this.shadowRadius = 0.8f;
        ModelPart modelPart = context.bakeLayer(BlimpBodyModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart, (String)"bakeLayer(...)");
        this.model = new BlimpBodyModel(modelPart);
        ModelPart modelPart2 = context.bakeLayer(BlimpTintModel.Companion.getLAYER_LOCATION());
        Intrinsics.checkNotNullExpressionValue((Object)modelPart2, (String)"bakeLayer(...)");
        this.colorModel = new BlimpTintModel(modelPart2);
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(@NotNull BlimpRenderState renderState, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderState), (String)"renderState");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.pushPose();
        poseStack.translate(0.0f, 1.5f, 0.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(270.0f - renderState.yRot));
        float f = renderState.hurtTime;
        if (f > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * renderState.damageTime / 10.0f * (float)renderState.hurtDir));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        this.model.setupAnim((EntityRenderState)renderState);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(this.model.renderType(this.texture));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        this.renderColorModel(poseStack, this.colorModel, bufferSource, this.texture, packedLight, renderState);
        poseStack.popPose();
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
    }

    private final void renderColorModel(PoseStack poseStack, EntityModel<BlimpRenderState> colorModel, MultiBufferSource buffer, ResourceLocation colorTexture, int packedLight, BlimpRenderState renderState) {
        poseStack.pushPose();
        colorModel.renderToBuffer(poseStack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)colorTexture)), packedLight, OverlayTexture.NO_OVERLAY, DyeColor.byId((int)renderState.getColorId()).getTextureDiffuseColor());
        poseStack.popPose();
    }

    @NotNull
    public BlimpRenderState createRenderState() {
        return new BlimpRenderState();
    }

    public void extractRenderState(@NotNull BlimpEntity entity, @NotNull BlimpRenderState reusedState, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)((Object)reusedState), (String)"reusedState");
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.yRot = entity.getYRot(partialTick);
        reusedState.hurtTime = (float)entity.getHurtTime() - partialTick;
        reusedState.hurtDir = entity.getHurtDir();
        reusedState.damageTime = (float)Math.max((double)(entity.getDamage() - partialTick), 0.0);
        reusedState.bubbleAngle = 0.0f;
        reusedState.isUnderWater = entity.isUnderWater();
        reusedState.rowingTimeLeft = entity.getRowingTime(0, partialTick);
        reusedState.rowingTimeRight = entity.getRowingTime(1, partialTick);
        reusedState.setColorId(entity.getColorId());
    }
}

