/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pixelbank.burnt.init.BurntModBlocks;
import net.pixelbank.burnt.network.BurntModVariables;

@Mod.EventBusSubscriber(modid="burnt", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BurntWorldIgnitionHooks {
    @SubscribeEvent
    public static void onSmallFireballImpact(ProjectileImpactEvent event) {
        Level level = event.getEntity().m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof SmallFireball)) {
            return;
        }
        if (event.getRayTraceResult().m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (!BurntModVariables.MapVariables.get((LevelAccessor)level).vanillaCatch) {
            return;
        }
        BlockHitResult bhr = (BlockHitResult)event.getRayTraceResult();
        BlockPos placePos = bhr.m_82425_().m_121945_(bhr.m_82434_());
        if (!level.m_8055_(placePos).m_60795_()) {
            return;
        }
        BlockState wouldBe = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)placePos);
        if (!wouldBe.m_60713_(Blocks.f_50083_)) {
            return;
        }
        if (level.m_8055_(placePos.m_7495_()).m_60713_(Blocks.f_50134_)) {
            return;
        }
        for (Direction d : Direction.values()) {
            if (!level.m_8055_(placePos.m_121945_(d)).m_60713_(Blocks.f_50080_)) continue;
            return;
        }
        event.setCanceled(true);
        level.m_7731_(placePos, ((Block)BurntModBlocks.FIRESTARTER.get()).m_49966_(), 11);
        event.getEntity().m_146870_();
    }

    @SubscribeEvent
    public static void onGhastFireballImpact(ProjectileImpactEvent event) {
        Level level = event.getEntity().m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof LargeFireball)) {
            return;
        }
        if (event.getRayTraceResult().m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (!BurntModVariables.MapVariables.get((LevelAccessor)level).vanillaCatch) {
            return;
        }
        BlockHitResult bhr = (BlockHitResult)event.getRayTraceResult();
        BlockPos impactPos = bhr.m_82425_();
        level.m_7654_().execute(() -> {
            for (BlockPos p : BlockPos.m_121940_((BlockPos)impactPos.m_7918_(-3, -3, -3), (BlockPos)impactPos.m_7918_(3, 3, 3))) {
                BlockState s = level.m_8055_(p);
                if (!s.m_60713_(Blocks.f_50083_) || level.m_8055_(p.m_7495_()).m_60713_(Blocks.f_50134_)) continue;
                level.m_7731_(p, ((Block)BurntModBlocks.FIRESTARTER.get()).m_49966_(), 11);
            }
        });
    }

    @SubscribeEvent
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        Level level;
        block8: {
            block7: {
                LevelAccessor levelAccessor = event.getLevel();
                if (!(levelAccessor instanceof Level)) break block7;
                level = (Level)levelAccessor;
                if (!level.f_46443_) break block8;
            }
            return;
        }
        if (!BurntModVariables.MapVariables.get((LevelAccessor)level).vanillaCatch) {
            return;
        }
        BlockState state = event.getState();
        if (!state.m_60713_(Blocks.f_50083_)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState current = level.m_8055_(pos);
        if (!current.m_60713_(Blocks.f_50083_)) {
            return;
        }
        if (level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50134_)) {
            return;
        }
        level.m_7731_(pos, ((Block)BurntModBlocks.FIRESTARTER.get()).m_49966_(), 11);
    }
}

