/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pixelbank.burnt.block.entity.BlastLeavesBlockEntity;
import net.pixelbank.burnt.init.BurntModBlocks;
import net.pixelbank.burnt.procedures.BlastLeavesTickProcedure;
import net.pixelbank.burnt.procedures.BurntLeavesDestroyedProcedure;
import net.pixelbank.burnt.procedures.BurntLeavesFireDamageProcedure;
import net.pixelbank.burnt.procedures.BurntLeavesSnowballProcedure;
import net.pixelbank.burnt.procedures.WoodParticlesProcedure;

public class BlastLeavesBlock
extends LeavesBlock
implements EntityBlock {
    public BlastLeavesBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283909_).m_60918_(SoundType.f_56740_).m_60978_(0.2f).m_60953_(s -> 10).m_60955_().m_60977_().m_278166_(PushReaction.DESTROY).m_60982_((bs, br, bp) -> true).m_60991_((bs, br, bp) -> true));
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidstate) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 3;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)BurntModBlocks.SMOLDERING_LEAVES.get());
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.DANGER_FIRE;
    }

    public void m_213897_(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(blockstate, world, pos, random);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlastLeavesTickProcedure.execute((LevelAccessor)world, x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.m_214162_(blockstate, world, pos, random);
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        WoodParticlesProcedure.execute((LevelAccessor)world, x, y, z);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        BurntLeavesDestroyedProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (Entity)entity);
        return retval;
    }

    public void m_7892_(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(blockstate, world, pos, entity);
        BurntLeavesFireDamageProcedure.execute((LevelAccessor)world, blockstate, entity);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.m_141947_(world, pos, blockstate, entity);
        BurntLeavesFireDamageProcedure.execute((LevelAccessor)world, blockstate, entity);
    }

    public void m_5581_(Level world, BlockState blockstate, BlockHitResult hit, Projectile entity) {
        BurntLeavesSnowballProcedure.execute((LevelAccessor)world, hit.m_82425_().m_123341_(), hit.m_82425_().m_123342_(), hit.m_82425_().m_123343_(), (Entity)entity);
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlastLeavesBlockEntity(pos, state);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity == null ? false : blockEntity.m_7531_(eventID, eventParam);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof BlastLeavesBlockEntity) {
                BlastLeavesBlockEntity be = (BlastLeavesBlockEntity)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)be);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof BlastLeavesBlockEntity) {
            BlastLeavesBlockEntity be = (BlastLeavesBlockEntity)tileentity;
            return AbstractContainerMenu.m_38938_((Container)be);
        }
        return 0;
    }
}

