/*
 * Decompiled with CFR 0.152.
 */
package net.pixelbank.burnt.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pixelbank.burnt.init.BurntModBlocks;
import net.pixelbank.burnt.procedures.BurntLogsFireDamageProcedure;
import net.pixelbank.burnt.procedures.FlamesPlacementProcedure;
import net.pixelbank.burnt.procedures.SmolderingHayTickProcedure;
import net.pixelbank.burnt.procedures.SmolderingPlanksParticlesProcedure;

public class SmolderingHayBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final BooleanProperty HOT = BooleanProperty.m_61465_((String)"hot");

    public SmolderingHayBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278183_().m_284180_(MapColor.f_283750_).m_60918_(SoundType.f_56758_).m_60978_(0.8f).m_60953_(s -> 12).m_278166_(PushReaction.DESTROY).m_60982_((bs, br, bp) -> true).m_60991_((bs, br, bp) -> true));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)HOT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidstate) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS, HOT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_())).m_61124_((Property)HOT, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
            if (state.m_61143_(AXIS) == Direction.Axis.X) {
                return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
            }
            if (state.m_61143_(AXIS) == Direction.Axis.Z) {
                return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
            }
        }
        return state;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)BurntModBlocks.BURNT_HAY.get());
    }

    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.DANGER_FIRE;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 18);
        FlamesPlacementProcedure.execute((LevelAccessor)world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public void m_213897_(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(blockstate, world, pos, random);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        SmolderingHayTickProcedure.execute((LevelAccessor)world, x, y, z);
        world.m_186460_(pos, (Block)this, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.m_214162_(blockstate, world, pos, random);
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        SmolderingPlanksParticlesProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
    }

    public void m_7892_(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.m_7892_(blockstate, world, pos, entity);
        BurntLogsFireDamageProcedure.execute((LevelAccessor)world, blockstate, entity);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.m_141947_(world, pos, blockstate, entity);
        BurntLogsFireDamageProcedure.execute((LevelAccessor)world, blockstate, entity);
    }
}

