/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.client.input;

import de.sarocesch.sarosroadblocksmod.SarosRoadBlocksModMod;
import de.sarocesch.sarosroadblocksmod.client.render.RoadPlannerClientRender;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModItems;
import de.sarocesch.sarosroadblocksmod.item.RoadPlannerItem;
import de.sarocesch.sarosroadblocksmod.network.RoadPlannerPackets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoadPlannerInputHandler {
    @SubscribeEvent
    public static void onScroll(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_6144_()) {
            return;
        }
        ItemStack held = player.m_21205_();
        if (held.m_41619_() || held.m_41720_() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return;
        }
        int width = RoadPlannerItem.getWidth(held);
        double delta = event.getScrollDelta();
        if (delta > 0.0) {
            ++width;
        } else if (delta < 0.0) {
            --width;
        }
        RoadPlannerItem.setWidth(held, width);
        SarosRoadBlocksModMod.PACKET_HANDLER.sendToServer((Object)new RoadPlannerPackets.C2SSetWidth(RoadPlannerItem.getWidth(held)));
        player.m_5661_((Component)Component.m_237113_((String)("Road Width: " + RoadPlannerItem.getWidth(held) + " blocks")), true);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (!player.m_9236_().m_5776_()) {
            return;
        }
        ItemStack held = player.m_21205_();
        if (held.m_41619_() || held.m_41720_() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return;
        }
        BlockPos nearest = RoadPlannerClientRender.findNearestWaypointByRay(10.0, 0.75);
        if (nearest == null) {
            return;
        }
        SarosRoadBlocksModMod.PACKET_HANDLER.sendToServer((Object)new RoadPlannerPackets.C2SClick(RoadPlannerPackets.C2SClick.Action.REMOVE, nearest));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (!player.m_9236_().m_5776_()) {
            return;
        }
        ItemStack held = player.m_21205_();
        if (held.m_41619_() || held.m_41720_() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return;
        }
        BlockPos nearest = RoadPlannerClientRender.findNearestWaypointByRay(10.0, 0.75);
        if (nearest == null) {
            return;
        }
        SarosRoadBlocksModMod.PACKET_HANDLER.sendToServer((Object)new RoadPlannerPackets.C2SClick(RoadPlannerPackets.C2SClick.Action.REMOVE, nearest));
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack held = player.m_21205_();
        if (held.m_41619_() || held.m_41720_() != SarosRoadBlocksModModItems.ROAD_PLANNER.get()) {
            return;
        }
        int width = RoadPlannerItem.getWidth(held);
        String label = "Road Width: " + width + " blocks";
        GuiGraphics gg = event.getGuiGraphics();
        int x = event.getWindow().m_85445_() / 2;
        int y = event.getWindow().m_85446_() - 60;
        gg.m_280137_(mc.f_91062_, label, x, y, -1);
    }
}

