/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.item;

import de.sarocesch.sarosroadblocksmod.config.ModConfigs;
import de.sarocesch.sarosroadblocksmod.road.RoadPlannerManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RoadPlannerItem
extends Item {
    public static final String NBT_WIDTH = "width";
    public static final int MIN_WIDTH = 3;
    public static final int MAX_WIDTH = 35;
    public static final int DEFAULT_WIDTH = 5;

    public RoadPlannerItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    public static int getWidth(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return 5;
        }
        CompoundTag tag = stack.m_41784_();
        int w = tag.m_128451_(NBT_WIDTH);
        if (w <= 0) {
            w = 5;
        }
        return Math.max(3, Math.min(35, w));
    }

    public static void setWidth(ItemStack stack, int width) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        int w = Math.max(3, Math.min(35, width));
        stack.m_41784_().m_128405_(NBT_WIDTH, w);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.saros_road_blocks_mod.road_planner"));
        tooltip.add((Component)Component.m_237113_((String)("Width: " + RoadPlannerItem.getWidth(stack) + " blocks")));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.saros_road_blocks_mod.road_planner_warning"));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockPos pos = ctx.m_8083_();
        int targetY = (int)Math.floor(ctx.m_43720_().f_82480_);
        pos = new BlockPos(pos.m_123341_(), targetY, pos.m_123343_());
        if (player.m_6144_()) {
            if (!level.m_5776_()) {
                RoadPlannerManager.clearWaypoints(level, player);
            }
            return InteractionResult.SUCCESS;
        }
        if (!level.m_5776_()) {
            if (RoadPlannerManager.isExistingWaypoint(level, player, pos)) {
                boolean built = RoadPlannerManager.buildPlannedRoad(level, player);
                if (!built && ((Boolean)ModConfigs.DEBUG_ROAD_PLANNER.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237113_((String)"No road built: need at least 2 waypoints"), true);
                }
            } else {
                RoadPlannerManager.addWaypoint(level, player, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

