/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.procedures;

import de.sarocesch.sarosroadblocksmod.block.AsphaltBlock;
import de.sarocesch.sarosroadblocksmod.block.SidewalkBlock;
import de.sarocesch.sarosroadblocksmod.init.SarosRoadBlocksModModBlocks;
import de.sarocesch.sarosroadblocksmod.util.RoadTextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StufenProcedure {
    public static void execute(Level world, double x, double y, double z, Player player) {
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof AsphaltBlock) {
            AsphaltBlock asphaltBlock = (AsphaltBlock)block;
            StufenProcedure.handleAsphalt(world, pos, state, player);
        } else {
            block = state.m_60734_();
            if (block instanceof SidewalkBlock) {
                SidewalkBlock sidewalkBlock = (SidewalkBlock)block;
                StufenProcedure.handleSidewalk(world, pos, state, player);
            }
        }
    }

    private static void handleAsphalt(Level world, BlockPos pos, BlockState state, Player player) {
        AsphaltBlock.Variant currentVariant = (AsphaltBlock.Variant)((Object)state.m_61143_(AsphaltBlock.VARIANT));
        Direction currentFacing = (Direction)state.m_61143_((Property)AsphaltBlock.FACING);
        if (currentVariant == AsphaltBlock.Variant.FIFTEEN) {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = world.m_8055_(belowPos);
            if (belowState.m_60734_() instanceof AsphaltBlock) {
                StufenProcedure.updateAsphaltBlock(world, belowPos, belowState, AsphaltBlock.Variant.DEFAULT, currentFacing);
                StufenProcedure.removeAndGiveItem(world, pos, player, new ItemStack((ItemLike)SarosRoadBlocksModModBlocks.ASPHALT.get()));
            }
        } else {
            AsphaltBlock.Variant nextVariant = StufenProcedure.getNextAsphaltVariant(currentVariant);
            StufenProcedure.updateAsphaltBlock(world, pos, state, nextVariant, currentFacing);
        }
    }

    private static void handleSidewalk(Level world, BlockPos pos, BlockState state, Player player) {
        SidewalkBlock.Variant currentVariant = (SidewalkBlock.Variant)((Object)state.m_61143_(SidewalkBlock.VARIANT));
        Direction currentFacing = (Direction)state.m_61143_((Property)SidewalkBlock.FACING);
        if (currentVariant == SidewalkBlock.Variant.FIFTEEN) {
            BlockPos belowPos = pos.m_7495_();
            BlockState belowState = world.m_8055_(belowPos);
            if (belowState.m_60734_() instanceof SidewalkBlock) {
                StufenProcedure.updateSidewalkBlock(world, belowPos, belowState, SidewalkBlock.Variant.DEFAULT, currentFacing);
                StufenProcedure.removeAndGiveItem(world, pos, player, new ItemStack((ItemLike)SarosRoadBlocksModModBlocks.SIDEWALK.get()));
            }
        } else {
            SidewalkBlock.Variant nextVariant = StufenProcedure.getNextSidewalkVariant(currentVariant);
            StufenProcedure.updateSidewalkBlock(world, pos, state, nextVariant, currentFacing);
        }
    }

    private static AsphaltBlock.Variant getNextAsphaltVariant(AsphaltBlock.Variant currentVariant) {
        return switch (currentVariant) {
            case AsphaltBlock.Variant.DEFAULT -> AsphaltBlock.Variant.ONE;
            case AsphaltBlock.Variant.ONE -> AsphaltBlock.Variant.TWO;
            case AsphaltBlock.Variant.TWO -> AsphaltBlock.Variant.THREE;
            case AsphaltBlock.Variant.THREE -> AsphaltBlock.Variant.FOUR;
            case AsphaltBlock.Variant.FOUR -> AsphaltBlock.Variant.FIVE;
            case AsphaltBlock.Variant.FIVE -> AsphaltBlock.Variant.SIX;
            case AsphaltBlock.Variant.SIX -> AsphaltBlock.Variant.SEVEN;
            case AsphaltBlock.Variant.SEVEN -> AsphaltBlock.Variant.EIGHT;
            case AsphaltBlock.Variant.EIGHT -> AsphaltBlock.Variant.NINE;
            case AsphaltBlock.Variant.NINE -> AsphaltBlock.Variant.TEN;
            case AsphaltBlock.Variant.TEN -> AsphaltBlock.Variant.ELEVEN;
            case AsphaltBlock.Variant.ELEVEN -> AsphaltBlock.Variant.TWELVE;
            case AsphaltBlock.Variant.TWELVE -> AsphaltBlock.Variant.THIRTEEN;
            case AsphaltBlock.Variant.THIRTEEN -> AsphaltBlock.Variant.FOURTEEN;
            case AsphaltBlock.Variant.FOURTEEN -> AsphaltBlock.Variant.FIFTEEN;
            default -> AsphaltBlock.Variant.FIFTEEN;
        };
    }

    private static SidewalkBlock.Variant getNextSidewalkVariant(SidewalkBlock.Variant currentVariant) {
        return switch (currentVariant) {
            case SidewalkBlock.Variant.DEFAULT -> SidewalkBlock.Variant.ONE;
            case SidewalkBlock.Variant.ONE -> SidewalkBlock.Variant.TWO;
            case SidewalkBlock.Variant.TWO -> SidewalkBlock.Variant.THREE;
            case SidewalkBlock.Variant.THREE -> SidewalkBlock.Variant.FOUR;
            case SidewalkBlock.Variant.FOUR -> SidewalkBlock.Variant.FIVE;
            case SidewalkBlock.Variant.FIVE -> SidewalkBlock.Variant.SIX;
            case SidewalkBlock.Variant.SIX -> SidewalkBlock.Variant.SEVEN;
            case SidewalkBlock.Variant.SEVEN -> SidewalkBlock.Variant.EIGHT;
            case SidewalkBlock.Variant.EIGHT -> SidewalkBlock.Variant.NINE;
            case SidewalkBlock.Variant.NINE -> SidewalkBlock.Variant.TEN;
            case SidewalkBlock.Variant.TEN -> SidewalkBlock.Variant.ELEVEN;
            case SidewalkBlock.Variant.ELEVEN -> SidewalkBlock.Variant.TWELVE;
            case SidewalkBlock.Variant.TWELVE -> SidewalkBlock.Variant.THIRTEEN;
            case SidewalkBlock.Variant.THIRTEEN -> SidewalkBlock.Variant.FOURTEEN;
            case SidewalkBlock.Variant.FOURTEEN -> SidewalkBlock.Variant.FIFTEEN;
            default -> SidewalkBlock.Variant.FIFTEEN;
        };
    }

    private static void updateAsphaltBlock(Level world, BlockPos pos, BlockState state, AsphaltBlock.Variant nextVariant, Direction facing) {
        String currentTexture = RoadTextureManager.getTextureForBlock(world, pos);
        BlockState newState = (BlockState)((BlockState)state.m_61124_(AsphaltBlock.VARIANT, (Comparable)((Object)nextVariant))).m_61124_((Property)AsphaltBlock.FACING, (Comparable)facing);
        world.m_7731_(pos, newState, 3);
        if (currentTexture != null && !currentTexture.isEmpty()) {
            RoadTextureManager.setTextureForBlock(world, pos, currentTexture);
        }
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void updateSidewalkBlock(Level world, BlockPos pos, BlockState state, SidewalkBlock.Variant nextVariant, Direction facing) {
        BlockState newState = (BlockState)((BlockState)state.m_61124_(SidewalkBlock.VARIANT, (Comparable)((Object)nextVariant))).m_61124_((Property)SidewalkBlock.FACING, (Comparable)facing);
        world.m_7731_(pos, newState, 3);
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void removeAndGiveItem(Level world, BlockPos pos, Player player, ItemStack itemStack) {
        world.m_7471_(pos, false);
        if (!player.m_7500_()) {
            player.m_36356_(itemStack);
        }
        world.m_5594_(null, pos, SoundEvents.f_11664_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

