/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosroadblocksmod.util;

import de.sarocesch.sarosroadblocksmod.block.entity.RoadBlockEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RoadTextureManager {
    private static RoadTextureManager instance;
    private final Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();
    private final Map<String, TextureSet> dynamicSets = new HashMap<String, TextureSet>();

    private RoadTextureManager() {
        this.registerDefaultTextures();
    }

    public static RoadTextureManager getInstance() {
        if (instance == null) {
            instance = new RoadTextureManager();
        }
        return instance;
    }

    public static void setTextureForBlockEntity(BlockEntity blockEntity, String textureId) {
        if (blockEntity instanceof RoadBlockEntity) {
            RoadBlockEntity roadBlockEntity = (RoadBlockEntity)blockEntity;
            roadBlockEntity.setTextureId(textureId);
            blockEntity.m_6596_();
        }
    }

    public static String getTextureFromBlockEntity(BlockEntity blockEntity) {
        if (blockEntity instanceof RoadBlockEntity) {
            RoadBlockEntity roadBlockEntity = (RoadBlockEntity)blockEntity;
            return roadBlockEntity.getTextureId();
        }
        return "default";
    }

    public static void setTextureForBlock(Level level, BlockPos pos, String textureId) {
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RoadBlockEntity) {
            RoadBlockEntity roadBlockEntity = (RoadBlockEntity)blockEntity;
            roadBlockEntity.setTextureId(textureId);
            blockEntity.m_6596_();
            BlockState state = level.m_8055_(pos);
            level.m_7260_(pos, state, state, 3);
            level.m_46745_(pos).m_8092_(true);
        }
    }

    public static String getTextureForBlock(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RoadBlockEntity) {
            return RoadTextureManager.getTextureFromBlockEntity(blockEntity);
        }
        return "default";
    }

    private void registerDefaultTextures() {
        this.registerTexture("default", "block/road_block_fine");
        this.registerTexture("straight", "block/road_block_linie");
        this.registerTexture("corner", "block/road_block_linie_ecke");
        this.registerTexture("cross", "block/road_block_kreuzung");
        this.registerTexture("two", "block/two");
        this.registerTexture("tt", "block/tt");
        this.registerTexture("tf", "block/tf");
        this.registerTexture("ts", "block/ts");
        this.registerTexture("tse", "block/tse");
        this.registerTexture("te", "block/te");
        this.registerTexture("nt", "block/nt");
        this.registerTexture("thirty", "block/thirty");
        this.registerTexture("ohae", "block/ohae");
        this.registerTexture("ohat", "block/ohat");
        this.registerTexture("tta", "block/tta");
        this.registerTexture("tts", "block/tts");
        this.registerTexture("ttd", "block/ttd");
        this.registerTexture("ttf", "block/ttf");
        this.registerTexture("ttg", "block/ttg");
        this.registerTexture("tth", "block/tth");
        this.registerTexture("ttj", "block/ttj");
        this.registerTexture("ttk", "block/ttk");
        this.registerTexture("corner_straight", "block/corner_straight");
    }

    public void registerTexture(String id, String texturePath) {
        this.textureMap.put(id, new ResourceLocation("saros_road_blocks_mod", texturePath));
    }

    public ResourceLocation getTexture(String id) {
        return this.textureMap.getOrDefault(id, this.textureMap.get("default"));
    }

    public void reload(ResourceManager resourceManager) {
        this.dynamicSets.clear();
        String basePath = "textures/block/lines";
        Map resources = resourceManager.m_214159_("textures/block/lines", rl -> rl.m_135815_().endsWith("/top.png"));
        for (Map.Entry entry : resources.entrySet()) {
            String dir;
            int idx2;
            ResourceLocation topLoc = (ResourceLocation)entry.getKey();
            String path = topLoc.m_135815_();
            int idx = path.lastIndexOf(47);
            if (idx <= 0 || (idx2 = (dir = path.substring(0, idx)).lastIndexOf(47)) <= 0) continue;
            String id = dir.substring(idx2 + 1);
            TextureSet set = new TextureSet();
            set.top = new ResourceLocation(topLoc.m_135827_(), dir + "/top.png");
            set.side = this.tryFace(resourceManager, topLoc.m_135827_(), dir + "/side.png");
            set.north = this.tryFace(resourceManager, topLoc.m_135827_(), dir + "/north.png");
            set.south = this.tryFace(resourceManager, topLoc.m_135827_(), dir + "/south.png");
            set.east = this.tryFace(resourceManager, topLoc.m_135827_(), dir + "/east.png");
            set.west = this.tryFace(resourceManager, topLoc.m_135827_(), dir + "/west.png");
            this.dynamicSets.put(id, set);
        }
    }

    private ResourceLocation tryFace(ResourceManager rm, String ns, String path) {
        ResourceLocation loc = new ResourceLocation(ns, path);
        return rm.m_213713_(loc).isPresent() ? loc : null;
    }

    public Set<String> getDynamicTextureIds() {
        return Collections.unmodifiableSet(this.dynamicSets.keySet());
    }

    public TextureSet getTextureSet(String id) {
        return this.dynamicSets.get(id);
    }

    public ResourceLocation getFaceTexture(String id, Face face) {
        TextureSet set = this.dynamicSets.get(id);
        if (set == null) {
            return null;
        }
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Face.TOP -> set.top;
            case Face.NORTH -> {
                if (set.north != null) {
                    yield set.north;
                }
                if (set.side != null) {
                    yield set.side;
                }
                yield null;
            }
            case Face.SOUTH -> {
                if (set.south != null) {
                    yield set.south;
                }
                if (set.side != null) {
                    yield set.side;
                }
                yield null;
            }
            case Face.EAST -> {
                if (set.east != null) {
                    yield set.east;
                }
                if (set.side != null) {
                    yield set.side;
                }
                yield null;
            }
            case Face.WEST -> {
                if (set.west != null) {
                    yield set.west;
                }
                if (set.side != null) {
                    yield set.side;
                }
                yield null;
            }
            case Face.SIDE -> set.side;
        };
    }

    public static class TextureSet {
        public ResourceLocation top;
        public ResourceLocation side;
        public ResourceLocation north;
        public ResourceLocation south;
        public ResourceLocation east;
        public ResourceLocation west;
    }

    public static enum Face {
        TOP,
        SIDE,
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

