/*
 * Decompiled with CFR 0.152.
 */
package com.mcresurgence;

import com.mcresurgence.ClientEntityFinder;
import com.mcresurgence.KillDisplayOverlay;
import com.mcresurgence.ModLogger;
import com.mcresurgence.ResurgentPVPStats;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DeathInfoPacket
implements IMessage {
    private UUID killerId;
    private UUID killedId;
    private String killerName;
    private String weaponRegistryName;
    private String killedName;

    public DeathInfoPacket() {
    }

    public DeathInfoPacket(UUID killer, String killerName, UUID killed, String killedName, String weapon) {
        this.killerId = killer;
        this.killerName = killerName;
        this.killedId = killed;
        this.weaponRegistryName = weapon;
        this.killedName = killedName;
    }

    public void fromBytes(ByteBuf buf) {
        long killerMost = buf.readLong();
        long killerLeast = buf.readLong();
        long killedMost = buf.readLong();
        long killedLeast = buf.readLong();
        this.killerId = new UUID(killerMost, killerLeast);
        this.killedId = new UUID(killedMost, killedLeast);
        this.killerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.weaponRegistryName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.killedName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.killerId.getMostSignificantBits());
        buf.writeLong(this.killerId.getLeastSignificantBits());
        buf.writeLong(this.killedId.getMostSignificantBits());
        buf.writeLong(this.killedId.getLeastSignificantBits());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.killerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.weaponRegistryName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.killedName);
    }

    public static class Handler
    implements IMessageHandler<DeathInfoPacket, IMessage> {
        public IMessage onMessage(DeathInfoPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                ItemStack weapon;
                ModLogger logger = ResurgentPVPStats.modLogger;
                EntityPlayer killer = Minecraft.func_71410_x().field_71441_e.func_72924_a(message.killerName);
                Entity killed = ClientEntityFinder.findEntityByUUID(message.killedId);
                Item weaponItem = Item.func_111206_d((String)message.weaponRegistryName);
                ItemStack itemStack = weapon = weaponItem != null ? new ItemStack(weaponItem) : new ItemStack(Items.field_151041_m);
                if (killer != null && killed != null) {
                    KillDisplayOverlay.displayKillInfo(killer.func_70005_c_(), weapon, killed.func_70005_c_(), killer, killed);
                    logger.info("Player " + killer.func_70005_c_() + " killed " + killed.func_70005_c_() + " using " + weapon.func_82833_r());
                } else {
                    logger.info("Error retrieving player data or weapon for kill display.");
                }
            });
            return null;
        }
    }
}

