/*
 * Decompiled with CFR 0.152.
 */
package com.mcresurgence;

import com.mcresurgence.KillEntry;
import com.mcresurgence.ModLogger;
import com.mcresurgence.ResurgentPVPStats;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class KillDisplayOverlay
extends Gui {
    private final Minecraft minecraft;
    private static final List<KillEntry> killEntries = new ArrayList<KillEntry>();
    private static final long FADE_DELAY = 5000L;
    private static final int headSize = 8;
    private static final int itemWidth = 16;
    private long lastTickTime = 0L;
    private static Map<KillEntry, Float> alphaMap = new HashMap<KillEntry, Float>();
    private static Map<KillEntry, Long> startTimeMap = new HashMap<KillEntry, Long>();
    private static final Map<KillEntry, Float> yPosMap = new HashMap<KillEntry, Float>();

    public KillDisplayOverlay(Minecraft mc) {
        this.minecraft = mc;
    }

    private int getTextColorFromAlpha(float alpha) {
        int alphaInt = (int)(alpha * 255.0f);
        return alphaInt << 24 | 0xFFFFFF;
    }

    public static void displayKillInfo(String killer, ItemStack weapon, String killed, EntityPlayer killerEntity, Entity killedEntity) {
        KillEntry entry = new KillEntry(killer, weapon, killed, killerEntity, killedEntity);
        killEntries.add(entry);
        alphaMap.put(entry, Float.valueOf(1.0f));
        startTimeMap.put(entry, System.currentTimeMillis());
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.drawOverlay();
        }
    }

    private void drawOverlay() {
        long currentTime = System.currentTimeMillis();
        long deltaTime = this.lastTickTime > 0L ? currentTime - this.lastTickTime : 0L;
        this.lastTickTime = currentTime;
        float moveRatePerSecond = 10.0f;
        float moveDistancePerTick = moveRatePerSecond * ((float)deltaTime / 1000.0f);
        float alphaFadePerSecond = 0.5f;
        float fadeRate = alphaFadePerSecond / 1000.0f;
        int baseYPos = 15;
        int paddingY = this.minecraft.field_71466_p.field_78288_b + 15;
        Iterator<KillEntry> iterator = killEntries.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            float targetYPos;
            KillEntry entry = iterator.next();
            float currentYPos = yPosMap.getOrDefault(entry, Float.valueOf(targetYPos = (float)(baseYPos + paddingY * index))).floatValue();
            if (currentYPos > targetYPos) {
                currentYPos = Math.max(targetYPos, currentYPos - moveDistancePerTick);
                yPosMap.put(entry, Float.valueOf(currentYPos));
            }
            Long startTime = startTimeMap.getOrDefault(entry, 0L);
            float alpha = alphaMap.getOrDefault(entry, Float.valueOf(1.0f)).floatValue();
            if (startTimeMap.containsKey(entry) && currentTime - startTime > 5000L) {
                alpha = Math.max(0.0f, alpha - fadeRate * (float)deltaTime);
                alphaMap.put(entry, Float.valueOf(alpha));
                if (alpha <= 0.0f) {
                    alphaMap.remove(entry);
                    startTimeMap.remove(entry);
                    yPosMap.remove(entry);
                    iterator.remove();
                    continue;
                }
            }
            this.drawEntry(entry, (int)currentYPos, alpha);
            ++index;
        }
    }

    private void drawEntry(KillEntry entry, int yPos, float alpha) {
        int entryPosStart = 8;
        int rectY = yPos - 3;
        int entryWidth = 250;
        int entryHeight = 20;
        int paddingHeadToText = 4;
        int entryStartX = entryPosStart;
        int entryEndX = entryPosStart + entryWidth;
        int centerX = (entryStartX + entryEndX) / 2;
        int itemPositionX = centerX - 8;
        int entryPaddingX = 16;
        float maxBGAlpha = 127.5f;
        int backgroundColor = (int)(alpha * maxBGAlpha) << 24 | 0;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        KillDisplayOverlay.func_73734_a((int)entryPosStart, (int)rectY, (int)(entryPosStart + entryWidth), (int)(rectY + entryHeight), (int)backgroundColor);
        int xPos = entryPaddingX;
        int textYOffset = yPos + 8 - this.minecraft.field_71466_p.field_78288_b / 2;
        this.renderPlayerHead(xPos, yPos, entry.getKillerEntity());
        this.displayText(entry.getKiller(), xPos += 8 + paddingHeadToText, textYOffset, alpha);
        int endX = entryWidth + entryPosStart - entryPaddingX;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)itemPositionX, (float)yPos, (float)0.0f);
        this.minecraft.func_175599_af().func_180450_b(entry.getWeapon(), 0, 0);
        GlStateManager.func_179121_F();
        int killedTextWidth = this.minecraft.field_71466_p.func_78256_a(entry.getKilled());
        int endTextX = endX - killedTextWidth;
        int endHeadX = endTextX - 8 - paddingHeadToText;
        if (entry.getKilledEntity() instanceof EntityPlayer) {
            EntityPlayer killedPlayer = (EntityPlayer)entry.getKilledEntity();
            this.renderPlayerHead(endHeadX, yPos, killedPlayer);
        }
        this.displayText(entry.getKilled(), endTextX, textYOffset, alpha);
        GlStateManager.func_179084_k();
    }

    private void displayText(String entry, int xPos, int textYOffset, float alpha) {
        this.minecraft.field_71466_p.func_175063_a(entry, (float)xPos, (float)textYOffset, this.getTextColorFromAlpha(alpha));
    }

    private void renderPlayerHead(int x, int y, EntityPlayer player) {
        ModLogger logger = ResurgentPVPStats.modLogger;
        logger.info("Attempting to renderPlayerHead");
        if (player == null) {
            return;
        }
        logger.info("Player is not null.");
        if (player.func_146103_bH() == null) {
            logger.info("player.getGameProfile() is null");
            return;
        }
        logger.info("player.getGameProfile() is not null");
        Collection properties = player.func_146103_bH().getProperties().get((Object)"textures");
        if (properties == null || properties.isEmpty()) {
            logger.info(String.format("Player [%s] has no texture properties. Continuing regardless.", player.func_145748_c_()));
        } else {
            logger.info(String.format("Player [%s] has texture properties. We could use one.", player.func_145748_c_()));
        }
        ResourceLocation skinLocation = null;
        if (Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId() == player.func_146103_bH().getId()) {
            logger.info(String.format("Player %s is the same as the minecraft gameprofile ID, using SP player's skin", player.func_145748_c_()));
            skinLocation = Minecraft.func_71410_x().field_71439_g.func_110306_p();
        } else {
            logger.info(String.format("Player %s is not the user on this client, trying next method.", player.func_145748_c_()));
        }
        Map map = this.minecraft.func_152342_ad().func_152788_a(player.func_146103_bH());
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            skinLocation = this.minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
            logger.info(String.format("Skin %s loaded via skinManager for player %s", skinLocation.toString(), player.func_145748_c_()));
        } else {
            logger.info(String.format("Failed to load skin for player %s.", player.func_145748_c_()));
        }
        if (skinLocation == null) {
            skinLocation = DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au());
            logger.info("Player skinLocation is null after all methods. Using default skin.");
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(skinLocation);
        GlStateManager.func_179109_b((float)x, (float)(y + 4), (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        KillDisplayOverlay.func_146110_a((int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
        GlStateManager.func_179121_F();
    }

    private float calculateYPosition(int index) {
        int baseYPos = 15;
        int paddingY = this.minecraft.field_71466_p.field_78288_b + 15;
        return baseYPos + paddingY * index;
    }
}

