/*
 * Decompiled with CFR 0.152.
 */
package com.mcresurgence;

import com.mcresurgence.DeathInfoPacket;
import com.mcresurgence.ModLogger;
import com.mcresurgence.NetworkHandler;
import com.mcresurgence.ResurgentPVPStats;
import com.mcresurgence.scorekeeping.KillScoreLoadManager;
import com.mcresurgence.scorekeeping.PlayerKillInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerKillEventHandler {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ModLogger logger = ResurgentPVPStats.modLogger;
        logger.info("LivingDeathEvent fired.");
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer killer = (EntityPlayer)event.getSource().func_76346_g();
            ItemStack weapon = killer.func_184614_ca();
            Entity killedEntity = event.getEntity();
            logger.info("Player " + killer.func_70005_c_() + " killed " + killedEntity.func_70005_c_() + " using " + weapon.func_82833_r());
            if (killedEntity instanceof EntityPlayer) {
                Entity killed = event.getEntity();
                PlayerKillInfo killInfo = new PlayerKillInfo(killed.func_110124_au(), killed.func_70005_c_(), weapon.func_77973_b().getRegistryName().toString());
                KillScoreLoadManager.recordKill(killer.func_110124_au(), killInfo);
                try {
                    NetworkHandler.INSTANCE.sendToAll((IMessage)new DeathInfoPacket(killer.func_110124_au(), killer.func_70005_c_(), killed.func_110124_au(), killed.func_70005_c_(), weapon.func_77973_b().getRegistryName().toString()));
                }
                catch (Exception e) {
                    logger.warn("Failed to trigger kill feed entry for the following: Player " + killer.func_70005_c_() + " killed " + killedEntity.func_70005_c_() + " using " + weapon.func_82833_r());
                }
            }
        }
    }
}

