/*
 * Decompiled with CFR 0.152.
 */
package com.mcresurgence.config;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraftforge.common.config.Configuration;

public class ResurgentPVPStatsConfiguration {
    private static Configuration clientConfig;
    private static Configuration serverConfig;

    public static void init(File configDir) {
        String clientConfigFilename = "client.cfg";
        String serverConfigFilename = "server.cfg";
        Path clientConfigPath = Paths.get(configDir.toString(), "resurgent-pvp-stats", clientConfigFilename);
        Path serverConfigPath = Paths.get(configDir.toString(), "resurgent-pvp-stats", serverConfigFilename);
        clientConfig = new Configuration(clientConfigPath.toFile());
        ResurgentPVPStatsConfiguration.loadClientConfig();
        serverConfig = new Configuration(serverConfigPath.toFile());
        ResurgentPVPStatsConfiguration.loadServerConfig();
    }

    private static void loadClientConfig() {
        clientConfig.load();
        clientConfig.getBoolean("enableKillFeed", "client", true, "Set to false to disable the kill feed on the client.");
        clientConfig.getInt("killFeedDuration", "client", 5, 1, 20, "Duration in seconds that the kill feed should appear on screen.");
        if (clientConfig.hasChanged()) {
            clientConfig.save();
        }
    }

    private static void loadServerConfig() {
        serverConfig.load();
        serverConfig.getBoolean("showPlayerNametags", "general", false, "Set to true to enable player nametags on the server.");
        if (serverConfig.hasChanged()) {
            serverConfig.save();
        }
    }

    public static boolean isKillFeedEnabled() {
        return clientConfig.getBoolean("enableKillFeed", "client", true, "Check if the kill feed is enabled.");
    }

    public static int getKillFeedDurationMillis() {
        int seconds = clientConfig.getInt("killFeedDuration", "client", 5, 1, 60, "Get the kill feed duration in seconds.");
        return seconds * 1000;
    }

    public static boolean isShowNametagsEnabled() {
        return serverConfig.getBoolean("showPlayerNametags", "general", false, "Check if nametags are shown.");
    }

    public static void setShowNametagsEnabled(boolean show) {
        serverConfig.get("general", "showPlayerNametags", false).set(show);
        if (serverConfig.hasChanged()) {
            serverConfig.save();
        }
    }
}

