/*
 * Decompiled with CFR 0.152.
 */
package com.mcresurgence.scorekeeping;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mcresurgence.ResurgentPVPStats;
import com.mcresurgence.scorekeeping.PlayerKillInfo;
import com.mcresurgence.scorekeeping.PlayerKillScoreEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class KillScoreLoadManager {
    private static Map<UUID, PlayerKillScoreEntry> playerKills = new HashMap<UUID, PlayerKillScoreEntry>();
    private static File dataFile;
    private static Gson gson;
    private static ExecutorService executor;

    public static void preInit(File configDir) {
        ResurgentPVPStats.modLogger.info("Initializing KillScoreLoadManager");
        String filename = "player-kills.json";
        Path path = Paths.get(configDir.toString(), "resurgent-pvp-stats", filename);
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            try {
                ResurgentPVPStats.modLogger.info("[KillScoreLoadManager] Parent directory exists.");
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                ResurgentPVPStats.modLogger.error("Failed to create directories: " + e.getMessage(), e);
                return;
            }
        }
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                ResurgentPVPStats.modLogger.info("[KillScoreLoadManager] Parent did not exist, successfully created it.");
            }
            catch (IOException e) {
                ResurgentPVPStats.modLogger.error("Failed to create the file: " + e.getMessage(), e);
                return;
            }
        }
        dataFile = path.toFile();
        KillScoreLoadManager.loadKills();
    }

    public static void recordKill(UUID killerUUID, PlayerKillInfo killInfo) {
        if (playerKills == null) {
            ResurgentPVPStats.modLogger.error("Attempted to record a kill before playerKills was initialized.");
            return;
        }
        ResurgentPVPStats.modLogger.info("Recording kill...");
        try {
            playerKills.computeIfAbsent(killerUUID, k -> new PlayerKillScoreEntry()).addKill(killInfo);
            KillScoreLoadManager.saveKillsAsync();
        }
        catch (Exception e) {
            ResurgentPVPStats.modLogger.error(String.format("[KillScoreLoadManager] could not record kill. Error: %s", e.getMessage()), e);
            ResurgentPVPStats.modLogger.info(String.format("Killer UUID: %s", killerUUID.toString()));
            ResurgentPVPStats.modLogger.info(String.format("killInfo: %s", killInfo.toString()));
        }
    }

    public static void saveKillsAsync() {
        CompletableFuture.runAsync(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(dataFile.getPath(), new String[0]), new OpenOption[0]);){
                gson.toJson(playerKills, (Appendable)writer);
            }
            catch (IOException e) {
                ResurgentPVPStats.modLogger.error("Failed to save kills data", e);
            }
        }, executor);
    }

    public static void loadKills() {
        if (!dataFile.exists()) {
            ResurgentPVPStats.modLogger.info("No existing kills data found, starting fresh.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(dataFile.getPath(), new String[0]));){
            Type type = new TypeToken<Map<UUID, PlayerKillScoreEntry>>(){}.getType();
            Map loadedKills = (Map)gson.fromJson((Reader)reader, type);
            if (loadedKills != null) {
                playerKills = loadedKills;
                ResurgentPVPStats.modLogger.warn("Successfully loaded kills data.");
            } else {
                ResurgentPVPStats.modLogger.warn("Kills data file was empty or corrupt. Starting with an empty map.");
                playerKills = new HashMap<UUID, PlayerKillScoreEntry>();
            }
        }
        catch (IOException e) {
            ResurgentPVPStats.modLogger.error("Failed to load kills data", e);
        }
    }

    static {
        gson = new Gson();
        executor = Executors.newSingleThreadExecutor();
    }
}

