/*
 * Decompiled with CFR 0.152.
 */
package com.fincode.cavechimes;

import net.minecraft.world.DimensionType;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@net.minecraftforge.common.config.Config(modid="cavechimes", category="")
@Mod.EventBusSubscriber(modid="cavechimes")
public final class Config {
    @Config.Name(value="Worldgen")
    @Config.Comment(value={"Controls options regarding naturally generated Cave Chimes."})
    @Config.LangKey(value="config.cavechimes.options.worldgen")
    public static WorldgenOptions worldgen = new WorldgenOptions();
    @Config.Name(value="Obtaining")
    @Config.Comment(value={"Controls the the various ways of obtaining Cave Chimes as an item."})
    @Config.LangKey(value="config.cavechimes.options.obtaining")
    public static ObtainingOptions obtaining = new ObtainingOptions();
    @Config.Name(value="Client")
    @Config.Comment(value={"Client-side options."})
    @Config.LangKey(value="config.cavechimes.options.client")
    public static ClientOptions client = new ClientOptions();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("cavechimes")) {
            ConfigManager.sync((String)"cavechimes", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class PriorityOptions {
        @Config.Name(value="Priority enabled")
        @Config.Comment(value={"Be warned, disabling this option may result in Cave Chimes not playing at times, as chimes nowhere near the player get priority over the ones the player may actually be able to hear."})
        @Config.LangKey(value="config.cavechimes.priority.enabled")
        public boolean enabled = true;
        @Config.Name(value="Chimes limit")
        @Config.Comment(value={"The amount of Cave Chimes the system will keep track of. If your render distance is above 16, I'd recommend increasing this."})
        @Config.LangKey(value="config.cavechimes.priority.limit")
        @Config.RangeInt(min=16, max=1024)
        public int limit = 300;
        @Config.Name(value="Refresh interval")
        @Config.Comment(value={"Time between Priority refreshes (in seconds). Values 1-10 recommended for aesthetic, values 5-20 recommended for performance."})
        @Config.LangKey(value="config.cavechimes.priority.refresh_rate")
        public int refreshInterval = 3;
    }

    public static class ClientOptions {
        @Config.Name(value="Volume modifier")
        @Config.Comment(value={"A multiplier for Cave Chimes volume."})
        @Config.LangKey(value="config.cavechimes.client.volume")
        @Config.RangeDouble(min=0.0, max=1.5)
        public double chimeVolume = 1.0;
        @Config.Name(value="Swing speed")
        @Config.Comment(value={"A multiplier for Cave Chimes animation speed."})
        @Config.LangKey(value="config.cavechimes.client.swing")
        @Config.RangeDouble(min=0.0, max=5.0)
        public double chimeSwing = 1.0;
        @Config.Name(value="Simplified model")
        @Config.Comment(value={"Replaces the Cave Chimes' custom model with a simplified cross model that lacks animations."})
        @Config.LangKey(value="config.cavechimes.client.simplified")
        @Config.RequiresMcRestart
        public boolean simplifiedModel = false;
        @Config.Name(value="Priority options")
        @Config.Comment(value={"Due to the way Minecraft's sound system works, a limit of 8 Cave Chimes can be producing sound at once. The priority system ensures that the 8 Chimes that are playing are the ones closest to the player."})
        @Config.LangKey(value="config.cavechimes.options.priority")
        public PriorityOptions priority = new PriorityOptions();
    }

    public static class ObtainingOptions {
        @Config.Name(value="Block drop")
        @Config.Comment(value={"Toggles Cave Chimes dropping themselves when broken."})
        @Config.LangKey(value="config.cavechimes.obtaining.block_drops")
        public boolean canBlockDrop = true;
        @Config.Name(value="Silk touch required")
        @Config.Comment(value={"If true, Cave Chimes will only drop themselves if mined with Silk Touch."})
        @Config.LangKey(value="config.cavechimes.obtaining.silk_touch")
        public boolean silkTouchRequired = false;
        @Config.Name(value="Crafting")
        @Config.Comment(value={"Toggles the Cave Chimes crafting recipe."})
        @Config.LangKey(value="config.cavechimes.obtaining.crafting")
        public boolean canCraft = true;
        @Config.Name(value="Creeper drops")
        @Config.Comment(value={"Toggles Creepers being able to drop Cave Chimes when killed by a Witch."})
        @Config.LangKey(value="config.cavechimes.obtaining.creeper_drops")
        public boolean canCreepersDrop = true;
    }

    public static class WorldgenOptions {
        @Config.Name(value="Generate Chimes")
        @Config.Comment(value={"If false, Cave Chimes will not generate naturally."})
        @Config.LangKey(value="config.cavechimes.worldgen.enabled")
        public boolean generateChimes = true;
        @Config.Name(value="Minimum height")
        @Config.Comment(value={"The minimum y-value at which Cave Chimes can generate."})
        @Config.LangKey(value="config.cavechimes.worldgen.height_min")
        public int minChimeHeight = 16;
        @Config.Name(value="Maximum height")
        @Config.Comment(value={"The maximum y-value at which Cave Chimes can generate."})
        @Config.LangKey(value="config.cavechimes.worldgen.height_max")
        public int maxChimeHeight = 35;
        @Config.Name(value="Generation frequency")
        @Config.Comment(value={"The chance for Cave Chimes to generate (per chunk)."})
        @Config.LangKey(value="config.cavechimes.worldgen.chance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double chimeFrequency = 0.3f;
        @Config.Name(value="Dimension list")
        @Config.Comment(value={"A whitelist/blacklist for which dimensions Cave Chimes generate in."})
        @Config.LangKey(value="config.cavechimes.worldgen.dimensions")
        public int[] dimensions = new int[]{DimensionType.OVERWORLD.func_186068_a()};
        @Config.Name(value="Dimension blacklist")
        @Config.Comment(value={"If enabled, the Dimension list will function as a blacklist instead of a whitelist."})
        @Config.LangKey(value="config.cavechimes.worldgen.dimensions_blacklist")
        public boolean dimBlacklist = false;
        @Config.Name(value="Biome list")
        @Config.Comment(value={"A whitelist/blacklist for which biomes Cave Chimes generate in."})
        @Config.LangKey(value="config.cavechimes.worldgen.biomes")
        public String[] biomes = new String[0];
        @Config.Name(value="Biome blacklist")
        @Config.Comment(value={"If enabled, the Biome list will function as a blacklist instead of a whitelist."})
        @Config.LangKey(value="config.cavechimes.worldgen.biomes_blacklist")
        public boolean biomeBlacklist = true;
    }
}

