/*
 * Decompiled with CFR 0.152.
 */
package com.fincode.cavechimes.client.audio;

import com.fincode.cavechimes.Config;
import com.fincode.cavechimes.init.CaveChimesSounds;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CaveChimesSound
extends PositionedSound
implements ITickableSound {
    public static final float BASE_VOLUME = 2.0f;
    private boolean playing = true;
    private short power = 0;
    private float configVolume;

    public CaveChimesSound(BlockPos pos) {
        super(CaveChimesSounds.CAVE_CHIMES, SoundCategory.BLOCKS);
        this.field_147666_i = ISound.AttenuationType.LINEAR;
        this.field_147659_g = true;
        this.field_147665_h = 0;
        this.configVolume = this.configure();
        this.field_147662_b = 2.0f * this.configVolume;
        this.setPos(pos);
    }

    public void stop() {
        this.playing = false;
        this.field_147659_g = false;
    }

    public void setVolume(short strength) {
        this.power = strength;
        this.updateVolume();
    }

    private void updateVolume() {
        this.field_147662_b = this.configure() * 2.0f * (1.0f - (float)this.power / 15.0f);
    }

    private float configure() {
        return (float)Config.client.chimeVolume;
    }

    public void setPos(BlockPos pos) {
        this.field_147660_d = pos.func_177958_n();
        this.field_147661_e = pos.func_177956_o();
        this.field_147658_f = pos.func_177952_p();
    }

    public void ping(boolean value) {
    }

    public boolean func_147667_k() {
        return !this.playing;
    }

    public void func_73660_a() {
        if (this.configVolume == this.configure()) {
            return;
        }
        this.configVolume = this.configure();
        this.updateVolume();
    }
}

