/*
 * Decompiled with CFR 0.152.
 */
package com.fincode.cavechimes.client.renderer;

import com.fincode.cavechimes.Config;
import com.fincode.cavechimes.client.model.ModelCaveChimes;
import com.fincode.cavechimes.common.block.entity.TileEntityCaveChimes;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class TileEntityCaveChimesRenderer
extends TileEntitySpecialRenderer<TileEntityCaveChimes> {
    private static final ResourceLocation TEXTURE_CHIMES = new ResourceLocation("cavechimes", "textures/entity/cave_chimes.png");
    private final ModelCaveChimes chimesModel = new ModelCaveChimes();
    private static final float SPEED_MULT = 0.08f;
    private static final float SPEED_BASE = 0.06f;
    private static final float SPEED_CHIMES = 0.1f;

    public void render(TileEntityCaveChimes chimes, double posX, double posY, double posZ, float subTick, int p_192841_9_, float p_192841_10_) {
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        ModelCaveChimes model = this.chimesModel;
        if (p_192841_9_ >= 0) {
            this.func_147499_a(field_178460_a[p_192841_9_]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            this.func_147499_a(TEXTURE_CHIMES);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        if (p_192841_9_ < 0) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)p_192841_10_);
        }
        GlStateManager.func_179109_b((float)((float)posX), (float)((float)posY + 1.0f), (float)((float)posZ));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)0.5f, (float)-0.5f, (float)-0.5f);
        float speed = (float)Config.client.chimeSwing * 0.08f;
        float swing = (float)(15 - chimes.getVolume()) / 15.0f;
        float time = (float)this.func_178459_a().func_82737_E() + subTick;
        if (speed != 0.0f) {
            model.body.field_78795_f = this.getAnimXBase(chimes, time, swing, speed);
            model.body.field_78808_h = this.getAnimZBase(chimes, time, swing, speed);
            model.chime_big.field_78795_f = this.getAnimXChime(chimes, time, swing, speed, chimes.chimeOffsets[0]);
            model.chime_big.field_78808_h = this.getAnimZChime(chimes, time, swing, speed, chimes.chimeOffsets[0]);
            model.chime_med_0.field_78795_f = this.getAnimXChime(chimes, time, swing, speed, chimes.chimeOffsets[1]);
            model.chime_med_0.field_78808_h = this.getAnimZChime(chimes, time, swing, speed, chimes.chimeOffsets[1]);
            model.chime_med_1.field_78795_f = this.getAnimXChime(chimes, time, swing, speed, chimes.chimeOffsets[2]);
            model.chime_med_1.field_78808_h = this.getAnimZChime(chimes, time, swing, speed, chimes.chimeOffsets[2]);
            model.chime_small.field_78795_f = this.getAnimXChime(chimes, time, swing, speed, chimes.chimeOffsets[3]);
            model.chime_small.field_78808_h = this.getAnimZChime(chimes, time, swing, speed, chimes.chimeOffsets[3]);
        } else {
            model.body.field_78795_f = 0.0f;
            model.body.field_78808_h = 0.0f;
            model.chime_big.field_78795_f = 0.0f;
            model.chime_big.field_78808_h = 0.0f;
            model.chime_med_0.field_78795_f = 0.0f;
            model.chime_med_0.field_78808_h = 0.0f;
            model.chime_med_1.field_78795_f = 0.0f;
            model.chime_med_1.field_78808_h = 0.0f;
            model.chime_small.field_78795_f = 0.0f;
            model.chime_small.field_78808_h = 0.0f;
        }
        model.renderAll();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (p_192841_9_ >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    private float getAnimSin(float partSpeed, float time, float speed) {
        return MathHelper.func_76126_a((float)(partSpeed * time * speed));
    }

    private float getAnimCos(float partSpeed, float time, float speed) {
        return MathHelper.func_76134_b((float)(partSpeed * time * speed));
    }

    private float getAnimXBase(TileEntityCaveChimes chimes, float time, float swing, float speed) {
        return this.getAnimSin(chimes.discSpeedX, time, speed) * 0.06f * swing;
    }

    private float getAnimZBase(TileEntityCaveChimes chimes, float time, float swing, float speed) {
        return this.getAnimCos(chimes.discSpeedZ, time, speed) * 0.06f * swing;
    }

    private float getAnimXChime(TileEntityCaveChimes chimes, float time, float swing, float speed, int chimeOffset) {
        return this.getAnimSin(chimes.discSpeedX, time + (float)chimeOffset, speed) * 0.1f * swing;
    }

    private float getAnimZChime(TileEntityCaveChimes chimes, float time, float swing, float speed, int chimeOffset) {
        return this.getAnimCos(chimes.discSpeedZ, time + (float)chimeOffset, speed) * 0.1f * swing;
    }
}

