/*
 * Decompiled with CFR 0.152.
 */
package com.fincode.cavechimes.common.block;

import com.fincode.cavechimes.CaveChimesMod;
import com.fincode.cavechimes.Config;
import com.fincode.cavechimes.common.block.entity.TileEntityCaveChimes;
import com.fincode.cavechimes.init.CaveChimesBlocks;
import com.fincode.cavechimes.init.CaveChimesItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCaveChimes
extends Block
implements ITileEntityProvider {
    public static PropertyInteger VOLUME = PropertyInteger.func_177719_a((String)"volume", (int)0, (int)15);
    protected static final AxisAlignedBB CHIMES_AABB = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 1.0, 0.75);

    public BlockCaveChimes() {
        super(Material.field_151573_f, MapColor.field_151670_w);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
        this.func_149713_g(0);
        this.func_149672_a(SoundType.field_185852_e);
        this.field_149758_A = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VOLUME, (Comparable)Integer.valueOf(0)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState p_185496_1_, IBlockAccess p_185496_2_, BlockPos p_185496_3_) {
        return CHIMES_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState p_180646_1_, IBlockAccess p_180646_2_, BlockPos p_180646_3_) {
        return field_185506_k;
    }

    public ItemStack func_185473_a(World p_185473_1_, BlockPos p_185473_2_, IBlockState p_185473_3_) {
        return new ItemStack(CaveChimesItems.CAVE_CHIMES);
    }

    public boolean canPlaceTorchOnTop(IBlockState p_canPlaceTorchOnTop_1_, IBlockAccess p_canPlaceTorchOnTop_2_, BlockPos p_canPlaceTorchOnTop_3_) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && BlockCaveChimes.canHang((IBlockAccess)world, pos);
    }

    public static boolean canHang(IBlockAccess world, BlockPos pos) {
        boolean can = !world.func_175623_d(pos.func_177984_a()) && world.func_180495_p(pos.func_177984_a()).isSideSolid(world, pos.func_177984_a(), EnumFacing.DOWN);
        return can;
    }

    public static boolean canHang(IBlockAccess world, BlockPos pos, IBlockState state, Block neighblock, BlockPos neighpos) {
        return neighpos != pos.func_177984_a();
    }

    public boolean func_149662_c(IBlockState p_149662_1_) {
        return false;
    }

    public boolean func_149686_d(IBlockState p_149686_1_) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState p_190946_1_) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState p_149645_1_) {
        return CaveChimesMod.isModelSimplified() ? EnumBlockRenderType.MODEL : EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing face, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_, EnumHand p_getStateForPlacement_9_) {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)VOLUME, (Comparable)Integer.valueOf(world.func_175687_A(pos)));
    }

    public void update(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K || !world.func_175640_z(pos) && (Integer)state.func_177229_b((IProperty)VOLUME) == 0) {
            return;
        }
        short power = (short)world.func_175687_A(pos);
        if (((Integer)state.func_177229_b((IProperty)VOLUME)).shortValue() != power) {
            this.updateVolume(world, pos, state, power);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos posOfNeighbor) {
        super.func_189540_a(state, world, pos, block, posOfNeighbor);
        this.neighborChangeInternal(world, pos, state, block, posOfNeighbor);
    }

    private void neighborChangeInternal(World world, BlockPos pos, IBlockState state, Block neighborBlock, BlockPos neighborPos) {
        if (!BlockCaveChimes.canHang((IBlockAccess)world, pos)) {
            this.breakChimes(world, pos);
            return;
        }
        if (state.func_177230_c() == CaveChimesBlocks.CAVE_CHIMES) {
            this.update(world, pos, state);
        }
    }

    private boolean canDrop() {
        return Config.obtaining.canBlockDrop;
    }

    private boolean requiresSilkTouch() {
        return Config.obtaining.silkTouchRequired;
    }

    private void breakChimes(World world, BlockPos pos) {
        if (Config.obtaining.canBlockDrop && !Config.obtaining.silkTouchRequired) {
            world.func_175655_b(pos, true);
            return;
        }
        world.func_175655_b(pos, false);
    }

    public boolean func_149659_a(Explosion p_149659_1_) {
        return super.func_149659_a(p_149659_1_) && this.canDrop() && !this.requiresSilkTouch();
    }

    public int quantityDropped(IBlockState p_quantityDropped_1_, int p_quantityDropped_2_, Random p_quantityDropped_3_) {
        return this.requiresSilkTouch() || !this.canDrop() ? 0 : 1;
    }

    public boolean canSilkHarvest(World p_canSilkHarvest_1_, BlockPos p_canSilkHarvest_2_, IBlockState p_canSilkHarvest_3_, EntityPlayer p_canSilkHarvest_4_) {
        return this.canDrop();
    }

    private void updateVolume(World world, BlockPos pos, IBlockState state, short volume) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)VOLUME, (Comparable)Integer.valueOf(volume)));
        TileEntity tE = world.func_175625_s(pos);
        if (tE instanceof TileEntityCaveChimes) {
            TileEntityCaveChimes chimes = (TileEntityCaveChimes)tE;
            chimes.setVolume(volume);
            return;
        }
        CaveChimesMod.getLogger().error("Cave Chimes at " + pos + " are not using the correct TileEntity! TileEntityCaveChimes expected, " + tE + " present.");
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCaveChimes();
    }

    public IBlockState func_176203_a(int p_176203_1_) {
        return this.func_176223_P().func_177226_a((IProperty)VOLUME, (Comparable)Integer.valueOf(p_176203_1_));
    }

    public int func_176201_c(IBlockState p_176201_1_) {
        return (Integer)p_176201_1_.func_177229_b((IProperty)VOLUME);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VOLUME});
    }

    @Nullable
    public TileEntity func_149915_a(World world, int i) {
        return new TileEntityCaveChimes();
    }
}

