/*
 * Decompiled with CFR 0.152.
 */
package com.fincode.cavechimes.common.block.entity;

import com.fincode.cavechimes.CaveChimesMod;
import com.fincode.cavechimes.Config;
import com.fincode.cavechimes.client.audio.CaveChimesSound;
import com.fincode.cavechimes.common.block.BlockCaveChimes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="cavechimes", value={Side.CLIENT})
public class TileEntityCaveChimes
extends TileEntity {
    @SideOnly(value=Side.CLIENT)
    private CaveChimesSound soundLoop;
    private boolean isPlaying = false;
    private short signal;
    public float discSpeedX = 0.0f;
    public float discSpeedZ = 0.0f;
    public int[] chimeOffsets = new int[4];
    private static final List<TileEntityCaveChimes> listeners = new ArrayList<TileEntityCaveChimes>();
    private static final List<TileEntityCaveChimes> playing = new ArrayList<TileEntityCaveChimes>();
    private static int interval = 0;

    private void addListener() {
        listeners.add(this);
    }

    private void removeListener() {
        listeners.remove((Object)this);
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public void onLoad() {
        super.onLoad();
        Random rand = this.field_145850_b.field_73012_v;
        this.discSpeedX = rand.nextFloat() + 0.5f;
        this.discSpeedZ = rand.nextFloat() + 0.5f;
        for (int o = 0; o < 4; ++o) {
            this.chimeOffsets[o] = rand.nextInt(8) - 7;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.signal = ((Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockCaveChimes.VOLUME)).shortValue();
            return;
        }
        this.soundLoop = new CaveChimesSound(this.field_174879_c);
        this.soundLoop.setVolume(this.signal);
        if (listeners.size() < Config.client.priority.limit) {
            this.addListener();
        } else {
            CaveChimesMod.getLogger().info("Cave Chimes limit exceeded! (" + listeners.size() + ")");
        }
        this.setPlaying(true);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.removeListener();
        this.setPlaying(false);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.removeListener();
        this.setPlaying(false);
    }

    public void setVolume(short volume) {
        if (this.signal == volume) {
            return;
        }
        this.signal = volume;
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.setPlaying(volume != 15);
        this.soundLoop.setVolume(volume);
    }

    public short getVolume() {
        return this.signal;
    }

    @SideOnly(value=Side.CLIENT)
    private void setPlayingInternal(boolean value) {
        if (value && !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.soundLoop)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.soundLoop);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.soundLoop);
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.soundLoop);
            this.soundLoop.stop();
        }
        this.isPlaying = value;
    }

    @SideOnly(value=Side.CLIENT)
    private void setPlaying(boolean value) {
        if (value == this.isPlaying) {
            return;
        }
        if (playing.size() >= 8 && value) {
            return;
        }
        this.setPlayingInternal(value);
        if (value) {
            playing.add(this);
        } else {
            playing.remove((Object)this);
        }
        this.soundLoop.ping(value);
    }

    @SideOnly(value=Side.CLIENT)
    private static void refresh(EntityPlayer player) {
        listeners.sort((c1, c2) -> (int)Math.signum(player.func_174818_b(c1.field_174879_c) - player.func_174818_b(c2.field_174879_c)));
        List<TileEntityCaveChimes> oldPlaying = playing;
        playing.clear();
        int l = 8;
        for (int c = 0; c < l && c < listeners.size(); ++c) {
            if (listeners.get(c).getVolume() != 15) {
                playing.add(listeners.get(c));
                continue;
            }
            ++l;
        }
        for (TileEntityCaveChimes chime : oldPlaying) {
            if (playing.contains((Object)chime)) continue;
            chime.setPlayingInternal(false);
        }
        for (TileEntityCaveChimes chime : playing) {
            if (oldPlaying.contains((Object)chime) && chime.isPlaying && Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)chime.soundLoop)) continue;
            chime.setPlayingInternal(true);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.CLIENT) {
            return;
        }
        int refreshInterval = Config.client.priority.refreshInterval * 20;
        if (!Config.client.priority.enabled || refreshInterval == 0) {
            return;
        }
        if (++interval < refreshInterval) {
            return;
        }
        interval = 0;
        TileEntityCaveChimes.refresh(event.player);
    }
}

