/*
 * Decompiled with CFR 0.152.
 */
package com.fincode.cavechimes.common.world.feature;

import com.fincode.cavechimes.Config;
import com.fincode.cavechimes.common.block.BlockCaveChimes;
import com.fincode.cavechimes.init.CaveChimesBlocks;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCaveChimes
implements IWorldGenerator {
    public static final int TRIES_GENERATION = 8;
    public static final int TRIES_HEIGHT = 20;

    public boolean generateChimes(World world, BlockPos blockPos) {
        if (world.func_175623_d(blockPos) && WorldGenCaveChimes.canHang((IBlockAccess)world, blockPos)) {
            world.func_180501_a(blockPos, CaveChimesBlocks.CAVE_CHIMES.func_176223_P(), 18);
            return true;
        }
        return false;
    }

    private static boolean canHang(IBlockAccess world, BlockPos pos) {
        return BlockCaveChimes.canHang(world, pos);
    }

    private boolean xor(boolean l, boolean r) {
        return !(!l && !r || l && r);
    }

    private boolean contains(int[] array, int value) {
        for (int i : array) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    private boolean contains(String[] array, String value) {
        for (String i : array) {
            if (!i.equals(value)) continue;
            return true;
        }
        return false;
    }

    public void generate(Random random, int cX, int cZ, World world, IChunkGenerator iChunkGenerator, IChunkProvider iChunkProvider) {
        int t;
        int heightMax;
        if (!Config.worldgen.generateChimes) {
            return;
        }
        if (!this.xor(this.contains(Config.worldgen.dimensions, world.field_73011_w.getDimension()), Config.worldgen.dimBlacklist)) {
            return;
        }
        int heightMin = MathHelper.func_76125_a((int)Config.worldgen.minChimeHeight, (int)1, (int)255);
        if (heightMin > (heightMax = MathHelper.func_76125_a((int)Config.worldgen.maxChimeHeight, (int)1, (int)255))) {
            return;
        }
        random = new Random(world.func_72905_C());
        long xSeed = random.nextLong() >> 3;
        long zSeed = random.nextLong() >> 3;
        random.setSeed(xSeed * (long)cX + zSeed * (long)cZ ^ world.func_72905_C());
        float atOdds = random.nextFloat();
        if ((double)atOdds > Config.worldgen.chimeFrequency) {
            return;
        }
        BlockPos pos = new BlockPos(cX * 16 + random.nextInt(15), 0, cZ * 16 + random.nextInt(15));
        ResourceLocation biome = world.field_73011_w.getBiomeForCoords(pos).getRegistryName();
        if (biome == null || !this.xor(this.contains(Config.worldgen.biomes, biome.func_110623_a()), Config.worldgen.biomeBlacklist)) {
            return;
        }
        for (t = 0; t < 8; ++t) {
            BlockPos tryPos;
            int tryHeight = random.nextInt(heightMax - heightMin) + heightMin;
            if (world.func_189649_b(pos.func_177958_n(), pos.func_177956_o()) <= tryHeight || !world.func_175623_d(tryPos = pos.func_177981_b(tryHeight))) continue;
            pos = tryPos;
            break;
        }
        for (t = 0; t < 20 && !this.generateChimes(world, pos); ++t) {
            pos = pos.func_177984_a();
        }
    }
}

