/*
 * Decompiled with CFR 0.152.
 */
package com.fincode.cavechimes.init;

import com.fincode.cavechimes.CaveChimesMod;
import com.fincode.cavechimes.client.model.BakedModelCaveChimes;
import com.fincode.cavechimes.client.renderer.TileEntityCaveChimesRenderer;
import com.fincode.cavechimes.common.block.entity.TileEntityCaveChimes;
import com.fincode.cavechimes.init.CaveChimesItems;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="cavechimes", value={Side.CLIENT})
public class CaveChimesClient {
    public static void registerRenderers() {
        boolean simplified = CaveChimesMod.isModelSimplified();
        CaveChimesMod.getLogger().info("Registering Cave Chimes renderer. " + (simplified ? "Using simplified model." : "Using normal model."));
        if (!simplified) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCaveChimes.class, (TileEntitySpecialRenderer)new TileEntityCaveChimesRenderer());
        }
    }

    @SubscribeEvent
    public static void register(ModelRegistryEvent event) {
        CaveChimesClient.registerItemModel(CaveChimesItems.CAVE_CHIMES);
    }

    @SubscribeEvent
    public static void bake(ModelBakeEvent event) {
        if (CaveChimesMod.isModelSimplified()) {
            return;
        }
        for (ModelResourceLocation location : event.getModelRegistry().func_148742_b()) {
            if (!location.func_110624_b().equals("cavechimes")) continue;
            IBakedModel original = (IBakedModel)event.getModelRegistry().func_82594_a((Object)location);
            if (!location.func_110623_a().contains("cave_chimes") || location.func_177518_c().contains("inventory") || original == null) continue;
            event.getModelRegistry().func_82595_a((Object)location, (Object)new BakedModelCaveChimes(original, event.getModelManager().func_174952_b().func_110572_b("minecraft:blocks/gold_block")));
        }
    }

    private static void registerItemModel(Item item) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{item.getRegistryName()});
        ResourceLocation name = item.getRegistryName();
        if (name == null) {
            return;
        }
        ModelLoader.setCustomMeshDefinition((Item)item, s -> new ModelResourceLocation(name, "inventory"));
    }
}

