/*
 * Decompiled with CFR 0.152.
 */
package com.norevy.particull;

import com.norevy.particull.client.gui.screen.PartiCullOptionsScreen;
import com.norevy.particull.config.PartiCullConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="particull")
public class PartiCull {
    public static final String MOD_ID = "particull";
    public static final Logger LOGGER = LogManager.getLogger((String)"particull");

    public PartiCull() {
        LOGGER.info("PartiCull: Mod Constructor - START");
        LOGGER.info("PartiCull: Registering ForgeConfigSpec.");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PartiCullConfig.CLIENT_SPEC, "particull-client.toml");
        LOGGER.info("PartiCull: ForgeConfigSpec registration call DONE.");
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new PartiCullOptionsScreen((Screen)screen)));
        LOGGER.info("PartiCull: Custom config screen factory registered.");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        LOGGER.info("PartiCull: Mod Constructor - END. Mod Initialized.");
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.m_91268_() != null) {
                int newApplicableFps;
                int refreshRate = mc.m_91268_().m_85377_();
                if (refreshRate <= 0) {
                    newApplicableFps = 60;
                    LOGGER.info("PartiCull: Invalid monitor refresh rate detected (<=0). Using fallback default: " + newApplicableFps + " FPS.");
                } else {
                    newApplicableFps = Math.max(30, Math.min(refreshRate, 360));
                    LOGGER.info("PartiCull: Detected monitor refresh rate: " + refreshRate + " FPS. Sanitized to: " + newApplicableFps + " FPS.");
                }
                PartiCullConfig.detectedRefreshRateDefault = newApplicableFps;
                if ((Integer)PartiCullConfig.CLIENT.targetFps.get() == 60) {
                    PartiCullConfig.CLIENT.targetFps.set((Object)newApplicableFps);
                    LOGGER.info("PartiCull: TargetFPS automatically set to: " + newApplicableFps + " FPS as it was the default.");
                } else {
                    LOGGER.info("PartiCull: TargetFPS was already set to " + String.valueOf(PartiCullConfig.CLIENT.targetFps.get()) + " by the user. Detected refresh rate default is " + newApplicableFps + " FPS.");
                }
            } else {
                PartiCullConfig.detectedRefreshRateDefault = 60;
                LOGGER.warn("PartiCull: Minecraft window not available during client setup to detect refresh rate. Using fallback " + PartiCullConfig.detectedRefreshRateDefault + " FPS for default info.");
            }
        });
    }
}

