/*
 * Decompiled with CFR 0.152.
 */
package com.norevy.particull.client.gui.screen;

import com.norevy.particull.PartiCull;
import com.norevy.particull.config.PartiCullConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class PartiCullOptionsScreen
extends Screen {
    private final Screen parentScreen;
    private EditBox targetFpsBox;
    private EditBox reductionSpeedBox;

    public PartiCullOptionsScreen(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"screen.particull.title"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        int topMargin = 35;
        int rowHeight = 20;
        int verticalSpacing = 4;
        int fullRowYIncrement = rowHeight + verticalSpacing;
        int shortInputWidth = 50;
        int inputXTargetCenter = this.f_96543_ / 2 + 30;
        int currentY = topMargin;
        int centerX = this.f_96543_ / 2;
        this.m_142416_((GuiEventListener)CycleButton.m_168916_((boolean)((Boolean)PartiCullConfig.CLIENT.modEnabled.get())).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.particull.enableMod"))).m_168936_(centerX - 100, currentY, 200, rowHeight, (Component)Component.m_237115_((String)"particull.setting.enableMod"), (button, newValue) -> PartiCullConfig.CLIENT.modEnabled.set(newValue)));
        this.targetFpsBox = new EditBox(this.f_96547_, inputXTargetCenter - shortInputWidth / 2, currentY += fullRowYIncrement + 5, shortInputWidth, rowHeight, CommonComponents.f_237098_);
        this.targetFpsBox.m_94144_(String.valueOf(PartiCullConfig.CLIENT.targetFps.get()));
        this.targetFpsBox.m_94153_(s -> s.isEmpty() || s.matches("-?[0-9]{1,3}"));
        this.m_142416_((GuiEventListener)this.targetFpsBox);
        this.reductionSpeedBox = new EditBox(this.f_96547_, inputXTargetCenter - shortInputWidth / 2, currentY += fullRowYIncrement, shortInputWidth, rowHeight, CommonComponents.f_237098_);
        this.reductionSpeedBox.m_94144_(String.valueOf(PartiCullConfig.CLIENT.reductionSpeed.get()));
        this.reductionSpeedBox.m_94153_(s -> {
            if (s.isEmpty()) {
                return true;
            }
            if (s.matches("[0-9]+")) {
                try {
                    int val = Integer.parseInt(s);
                    return val >= 0 && val <= 10 && s.length() <= 2;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        });
        this.m_142416_((GuiEventListener)this.reductionSpeedBox);
        int buttonWidth = 98;
        int buttonY = this.f_96544_ - rowHeight - 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.saveSettings();
            this.f_96541_.m_91152_(this.parentScreen);
        }).m_252987_(centerX + verticalSpacing, buttonY, buttonWidth, rowHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(this.parentScreen)).m_252987_(centerX - buttonWidth - verticalSpacing, buttonY, buttonWidth, rowHeight).m_253136_());
    }

    private void saveSettings() {
        try {
            int newTargetFps;
            String fpsValue = this.targetFpsBox.m_94155_();
            int n = newTargetFps = fpsValue.isEmpty() ? (Integer)PartiCullConfig.CLIENT.targetFps.getDefault() : Integer.parseInt(fpsValue);
            if (newTargetFps >= 0 && newTargetFps <= 360) {
                PartiCullConfig.CLIENT.targetFps.set((Object)newTargetFps);
            } else {
                PartiCullConfig.CLIENT.targetFps.set((Object)((Integer)PartiCullConfig.CLIENT.targetFps.getDefault()));
                PartiCull.LOGGER.warn("Invalid Target FPS value entered ('{}'), resetting to default.", (Object)fpsValue);
            }
        }
        catch (NumberFormatException e) {
            PartiCullConfig.CLIENT.targetFps.set((Object)((Integer)PartiCullConfig.CLIENT.targetFps.getDefault()));
            PartiCull.LOGGER.warn("Failed to parse Target FPS value ('{}'), resetting to default.", (Object)this.targetFpsBox.m_94155_(), (Object)e);
        }
        try {
            int newAgg;
            String aggValue = this.reductionSpeedBox.m_94155_();
            int n = newAgg = aggValue.isEmpty() ? (Integer)PartiCullConfig.CLIENT.reductionSpeed.getDefault() : Integer.parseInt(aggValue);
            if (newAgg >= 0 && newAgg <= 10) {
                PartiCullConfig.CLIENT.reductionSpeed.set((Object)newAgg);
            } else {
                PartiCullConfig.CLIENT.reductionSpeed.set((Object)((Integer)PartiCullConfig.CLIENT.reductionSpeed.getDefault()));
                PartiCull.LOGGER.warn("Invalid Reduction Speed value entered ('{}'), resetting to default.", (Object)aggValue);
            }
        }
        catch (NumberFormatException e) {
            PartiCullConfig.CLIENT.reductionSpeed.set((Object)((Integer)PartiCullConfig.CLIENT.reductionSpeed.getDefault()));
            PartiCull.LOGGER.warn("Failed to parse Reduction Speed value ('{}'), resetting to default.", (Object)this.reductionSpeedBox.m_94155_(), (Object)e);
        }
        PartiCullConfig.CLIENT_SPEC.save();
    }

    public void m_280273_(GuiGraphics gg) {
        super.m_280039_(gg);
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gg);
        super.m_88315_(gg, mouseX, mouseY, partialTicks);
        gg.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        int labelRightAlignX = this.targetFpsBox.m_252754_() - 10;
        MutableComponent targetFpsLabel = Component.m_237115_((String)"particull.setting.targetFps.label");
        gg.m_280430_(this.f_96547_, (Component)targetFpsLabel, labelRightAlignX - this.f_96547_.m_92852_((FormattedText)targetFpsLabel), this.targetFpsBox.m_252907_() + (this.targetFpsBox.m_93694_() - 8) / 2, -2039584);
        MutableComponent reductionSpeedLabel = Component.m_237115_((String)"particull.setting.reductionSpeed.label");
        gg.m_280430_(this.f_96547_, (Component)reductionSpeedLabel, labelRightAlignX - this.f_96547_.m_92852_((FormattedText)reductionSpeedLabel), this.reductionSpeedBox.m_252907_() + (this.reductionSpeedBox.m_93694_() - 8) / 2, -2039584);
        if (this.targetFpsBox.m_5953_((double)mouseX, (double)mouseY)) {
            MutableComponent targetFpsTooltip = Component.m_237110_((String)"tooltip.particull.targetFps.description", (Object[])new Object[]{PartiCullConfig.detectedRefreshRateDefault});
            gg.m_280557_(this.f_96547_, (Component)targetFpsTooltip, mouseX, mouseY);
        }
        if (this.reductionSpeedBox.m_5953_((double)mouseX, (double)mouseY)) {
            MutableComponent reductionSpeedTooltip = Component.m_237110_((String)"tooltip.particull.reductionSpeed.description", (Object[])new Object[]{PartiCullConfig.CLIENT.reductionSpeed.getDefault()});
            gg.m_280557_(this.f_96547_, (Component)reductionSpeedTooltip, mouseX, mouseY);
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }
}

