/*
 * Decompiled with CFR 0.152.
 */
package com.norevy.particull.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PartiCullConfig {
    public static final int STATIC_FALLBACK_DEFAULT_TARGET_FPS = 60;
    public static int detectedRefreshRateDefault = 60;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue modEnabled;
        public final ForgeConfigSpec.IntValue targetFps;
        public final ForgeConfigSpec.IntValue reductionSpeed;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("PartiCull Client Configuration").push("General");
            this.modEnabled = builder.comment("Enables or disables the PartiCull mod functionality globally.").translation("particull.config.modEnabled").define("modEnabled", true);
            this.targetFps = builder.comment("Target FPS. If current FPS drops below this, particle reduction activates. Defaults to your monitor's refresh rate (fallback 60 FPS) on first launch if not manually set.").translation("particull.config.targetFps").defineInRange("targetFps", 60, 0, 360);
            this.reductionSpeed = builder.comment("Defines how quickly particle reduction occurs. 0-5 for stepped reduction (ALL -> DECREASED -> MINIMAL). 6-10 for direct reduction (ALL -> MINIMAL).").translation("particull.config.reductionSpeed").defineInRange("reductionSpeed", 3, 0, 10);
            builder.pop();
        }
    }
}

