/*
 * Decompiled with CFR 0.152.
 */
package com.norevy.particull.event;

import com.norevy.particull.config.PartiCullConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.ParticleStatus;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="particull", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientForgeEvents {
    private static ParticleStatus originalParticleSetting = null;
    private static boolean vanillaSettingChangedByMod = false;
    private static boolean reductionActive = false;
    private static boolean previousReductionActive = false;
    private static int ticksBelowTargetThreshold = 0;
    private static int ticksAtOrAboveTargetThreshold = 0;
    private static final int STABILIZATION_TICKS_TO_ACTIVATE = 10;
    private static final int STABILIZATION_TICKS_TO_DEACTIVATE = 20;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean shouldBeActiveNow;
        int minimalFpsThreshold;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            if (vanillaSettingChangedByMod) {
                ClientForgeEvents.restoreOriginalParticleSetting(minecraft.f_91066_);
                reductionActive = false;
                previousReductionActive = false;
                vanillaSettingChangedByMod = false;
                originalParticleSetting = null;
                ticksBelowTargetThreshold = 0;
                ticksAtOrAboveTargetThreshold = 0;
            }
            return;
        }
        boolean modGloballyEnabled = (Boolean)PartiCullConfig.CLIENT.modEnabled.get();
        if (!modGloballyEnabled) {
            if (vanillaSettingChangedByMod) {
                ClientForgeEvents.restoreOriginalParticleSetting(minecraft.f_91066_);
            }
            reductionActive = false;
            previousReductionActive = false;
            ticksBelowTargetThreshold = 0;
            ticksAtOrAboveTargetThreshold = 0;
            return;
        }
        int currentFps = minecraft.m_260875_();
        int baseTargetFps = (Integer)PartiCullConfig.CLIENT.targetFps.get();
        int reductionSpeed = (Integer)PartiCullConfig.CLIENT.reductionSpeed.get();
        Options gameOptions = minecraft.f_91066_;
        ParticleStatus desiredStatus = baseTargetFps == 0 ? (reductionSpeed >= 6 ? ParticleStatus.MINIMAL : ParticleStatus.DECREASED) : (reductionSpeed >= 6 ? (currentFps >= baseTargetFps ? ParticleStatus.ALL : ParticleStatus.MINIMAL) : (currentFps < (minimalFpsThreshold = (int)((double)baseTargetFps * 0.7)) ? ParticleStatus.MINIMAL : (currentFps < baseTargetFps ? ParticleStatus.DECREASED : ParticleStatus.ALL)));
        boolean bl = shouldBeActiveNow = desiredStatus != ParticleStatus.ALL;
        if (shouldBeActiveNow) {
            ++ticksBelowTargetThreshold;
            ticksAtOrAboveTargetThreshold = 0;
        } else {
            ++ticksAtOrAboveTargetThreshold;
            ticksBelowTargetThreshold = 0;
        }
        previousReductionActive = reductionActive;
        if (ticksBelowTargetThreshold >= 10) {
            reductionActive = true;
        } else if (ticksAtOrAboveTargetThreshold >= 20) {
            reductionActive = false;
        }
        if (previousReductionActive && !reductionActive && ticksAtOrAboveTargetThreshold < 20) {
            reductionActive = true;
        }
        if (reductionActive && !previousReductionActive) {
            ClientForgeEvents.applyParticleReduction(gameOptions, desiredStatus);
        } else if (!reductionActive && previousReductionActive) {
            ClientForgeEvents.restoreOriginalParticleSetting(gameOptions);
        } else if (reductionActive && gameOptions.m_231929_().m_231551_() != desiredStatus) {
            ClientForgeEvents.applyParticleReduction(gameOptions, desiredStatus);
        }
        if (vanillaSettingChangedByMod && reductionActive && gameOptions.m_231929_().m_231551_() != desiredStatus) {
            gameOptions.m_231929_().m_231514_((Object)desiredStatus);
        }
    }

    private static void applyParticleReduction(Options gameOptions, ParticleStatus targetStatus) {
        if (!vanillaSettingChangedByMod) {
            originalParticleSetting = (ParticleStatus)gameOptions.m_231929_().m_231551_();
            vanillaSettingChangedByMod = true;
        }
        if (gameOptions.m_231929_().m_231551_() != targetStatus) {
            gameOptions.m_231929_().m_231514_((Object)targetStatus);
        }
    }

    private static void restoreOriginalParticleSetting(Options gameOptions) {
        if (vanillaSettingChangedByMod && originalParticleSetting != null && gameOptions.m_231929_().m_231551_() != originalParticleSetting) {
            gameOptions.m_231929_().m_231514_((Object)originalParticleSetting);
        }
        vanillaSettingChangedByMod = false;
        originalParticleSetting = null;
        ticksBelowTargetThreshold = 0;
        ticksAtOrAboveTargetThreshold = 0;
    }
}

