/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@MethodsReturnNonnullByDefault
public class Logic13 {
    private static final int SINGLE_CHEST_SLOTS = 18;
    private static final int DOUBLE_CHEST_SLOTS = 27;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic13());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onRightClickChest(PlayerInteractEvent.RightClickBlock event) {
        int capSlots;
        int rows;
        Player player = event.getEntity();
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof EnderChestBlock) {
            PlayerEnderChestContainer original = sp.getEnderChestInventory();
            final LimitedContainer limited = new LimitedContainer((Container)original, 18);
            MenuProvider provider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.enderchest");
                }

                public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
                    return new ChestMenu(MenuType.GENERIC_9x1, id, playerInventory, limited, 1);
                }
            };
            sp.openMenu(provider);
            event.setCanceled(true);
            return;
        }
        if (!(block instanceof ChestBlock) && !(block instanceof TrappedChestBlock)) {
            return;
        }
        ChestBlock chestBlock = (ChestBlock)block;
        Container original = ChestBlock.getContainer((ChestBlock)chestBlock, (BlockState)state, (Level)((ServerLevel)level), (BlockPos)pos, (boolean)true);
        if (original == null) {
            return;
        }
        if (original.getContainerSize() > 27) {
            rows = 3;
            capSlots = 27;
        } else {
            rows = 2;
            capSlots = 18;
        }
        final LimitedContainer limited = new LimitedContainer(original, capSlots);
        final int finalRows = rows;
        MenuProvider provider = new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)"container.chest");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
                if (finalRows == 2) {
                    return new ChestMenu(MenuType.GENERIC_9x2, id, playerInventory, limited, 2);
                }
                return new ChestMenu(MenuType.GENERIC_9x1, id, playerInventory, limited, 1);
            }
        };
        sp.openMenu(provider);
        event.setCanceled(true);
    }

    private static final class LimitedContainer
    implements Container {
        private final Container delegate;
        private final int size;

        LimitedContainer(Container delegate, int size) {
            this.delegate = delegate;
            this.size = Math.min(size, delegate.getContainerSize());
        }

        public int getContainerSize() {
            return this.size;
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.size; ++i) {
                if (this.delegate.getItem(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int index) {
            if (index < 0 || index >= this.size) {
                return ItemStack.EMPTY;
            }
            return this.delegate.getItem(index);
        }

        public ItemStack removeItem(int index, int count) {
            if (index < 0 || index >= this.size) {
                return ItemStack.EMPTY;
            }
            return this.delegate.removeItem(index, count);
        }

        public ItemStack removeItemNoUpdate(int index) {
            if (index < 0 || index >= this.size) {
                return ItemStack.EMPTY;
            }
            return this.delegate.removeItemNoUpdate(index);
        }

        public void setItem(int index, ItemStack stack) {
            if (index < 0 || index >= this.size) {
                return;
            }
            this.delegate.setItem(index, stack);
        }

        public void setChanged() {
            this.delegate.setChanged();
        }

        public boolean stillValid(Player player) {
            return this.delegate.stillValid(player);
        }

        public boolean canPlaceItem(int index, ItemStack stack) {
            if (index < 0 || index >= this.size) {
                return false;
            }
            return this.delegate.canPlaceItem(index, stack);
        }

        public void startOpen(Player player) {
            this.delegate.startOpen(player);
        }

        public void stopOpen(Player player) {
            this.delegate.stopOpen(player);
        }

        public void clearContent() {
            for (int i = 0; i < this.size; ++i) {
                this.delegate.setItem(i, ItemStack.EMPTY);
            }
            this.delegate.setChanged();
        }
    }
}

