/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic16 {
    private static final Map<UUID, Long> SPIDER_COOLDOWN = new HashMap<UUID, Long>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic16());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double radius = 2.3;
        List spiders = serverLevel.getEntitiesOfClass(Spider.class, player.getBoundingBox().inflate(radius));
        if (spiders.isEmpty()) {
            return;
        }
        if (!player.onGround()) {
            return;
        }
        BlockPos pos = BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ());
        if (!serverLevel.getBlockState(pos).isAir()) {
            return;
        }
        long now = serverLevel.getGameTime();
        long COOLDOWN_TICKS = 60L;
        for (Spider spider : spiders) {
            UUID id = spider.getUUID();
            long last = SPIDER_COOLDOWN.getOrDefault(id, 0L);
            if (now - last < 60L) continue;
            SPIDER_COOLDOWN.put(id, now);
            serverLevel.setBlockAndUpdate(pos, Blocks.COBWEB.defaultBlockState());
            break;
        }
    }
}

