/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic17 {
    private static final Map<UUID, Long> BOAT_DESTRUCTION_TIME = new HashMap<UUID, Long>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic17());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player.level();
        Entity entity = player.getVehicle();
        if (!(entity instanceof Boat)) {
            return;
        }
        Boat boat = (Boat)entity;
        long now = serverLevel.getGameTime();
        UUID boatId = boat.getUUID();
        Long scheduled = BOAT_DESTRUCTION_TIME.get(boatId);
        if (scheduled == null) {
            int delayTicks = ThreadLocalRandom.current().nextInt(300, 601);
            BOAT_DESTRUCTION_TIME.put(boatId, now + (long)delayTicks);
            return;
        }
        if (now >= scheduled) {
            boat.hurt(boat.damageSources().generic(), 10000.0f);
            BOAT_DESTRUCTION_TIME.remove(boatId);
        }
    }
}

