/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class Logic2 {
    private static boolean active = false;
    private static boolean changingTarget = false;

    public static void init() {
        NeoForge.EVENT_BUS.addListener(Logic2::onLivingIncomingDamage);
        NeoForge.EVENT_BUS.addListener(Logic2::onLivingChangeTarget);
    }

    public static void run(Player player) {
        active = true;
    }

    private static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        if (!active) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (entity.level().isClientSide()) {
            return;
        }
        if (entity instanceof Zombie || entity instanceof Skeleton) {
            DamageSource src = event.getSource();
            if (src == null) {
                return;
            }
            if (src.is(DamageTypes.ON_FIRE) || src.is(DamageTypes.IN_FIRE) || src.is(DamageTypes.LAVA) || src.is(DamageTypes.HOT_FLOOR)) {
                event.setCanceled(true);
                entity.clearFire();
                entity.setRemainingFireTicks(0);
            }
        }
    }

    private static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        if (!active) {
            return;
        }
        if (changingTarget) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (entity.level().isClientSide()) {
            return;
        }
        if (!(entity instanceof Spider)) {
            return;
        }
        Spider spider = (Spider)entity;
        event.setCanceled(true);
        List players = spider.level().getEntitiesOfClass(Player.class, spider.getBoundingBox().inflate(32.0));
        Optional<Player> nearest = players.stream().min(Comparator.comparingDouble(p -> spider.distanceToSqr((Entity)p)));
        nearest.ifPresent(target -> {
            if (spider.getTarget() == target) {
                return;
            }
            try {
                changingTarget = true;
                spider.setTarget((LivingEntity)target);
            }
            finally {
                changingTarget = false;
            }
        });
    }
}

