/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class Logic20 {
    private static final String TAG_KEY = "complicatedminecraftmod_addedThrowTNTGoal";
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic20());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)entity;
        CompoundTag data = creeper.getPersistentData();
        if (data.contains(TAG_KEY)) {
            return;
        }
        creeper.goalSelector.addGoal(2, (Goal)new ThrowTntAtPlayerGoal(creeper));
        data.putBoolean(TAG_KEY, true);
    }

    static class ThrowTntAtPlayerGoal
    extends Goal {
        private static final double RANGE = 20.0;
        private static final int COOLDOWN_TICKS = 120;
        private final Creeper creeper;
        private int cooldown;

        ThrowTntAtPlayerGoal(Creeper creeper) {
            this.creeper = creeper;
            this.cooldown = creeper.getRandom().nextInt(120);
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            Player player = this.creeper.level().getNearestPlayer((Entity)this.creeper, 20.0);
            return player != null;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.throwTntAtNearestPlayer();
            this.cooldown = 120;
        }

        private void throwTntAtNearestPlayer() {
            Level level = this.creeper.level();
            if (level.isClientSide()) {
                return;
            }
            Player player = level.getNearestPlayer((Entity)this.creeper, 20.0);
            if (player == null) {
                return;
            }
            PrimedTnt tnt = new PrimedTnt(level, this.creeper.getX(), this.creeper.getEyeY(), this.creeper.getZ(), (LivingEntity)this.creeper);
            tnt.setFuse(40);
            Vec3 dir = new Vec3(player.getX() - this.creeper.getX(), player.getEyeY() - this.creeper.getEyeY(), player.getZ() - this.creeper.getZ()).normalize();
            tnt.setDeltaMovement(dir.scale(0.6).add(0.0, 0.2, 0.0));
            level.addFreshEntity((Entity)tnt);
        }
    }
}

