/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class Logic25 {
    private static final int TICK_INTERVAL = 200;
    private static final int RADIUS_MIN = 24;
    private static final int RADIUS_MAX = 48;
    private static final int LOCAL_CAP = 12;
    private static int tickCounter = 0;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic25());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        if (tickCounter++ % 200 != 0) {
            return;
        }
        for (ServerLevel level : server.getAllLevels()) {
            if (level.getPlayers(p -> true).isEmpty()) continue;
            for (ServerPlayer player : level.players()) {
                AABB box;
                int hostileCount;
                if (player.isSpectator() || player.isCreative() || (hostileCount = level.getEntitiesOfClass(Monster.class, box = new AABB(player.blockPosition()).inflate(32.0)).size()) >= 12) continue;
                RandomSource rnd = level.getRandom();
                this.trySpawnHostileNear(level, player, rnd, true);
                if (rnd.nextBoolean()) {
                    this.trySpawnHostileNear(level, player, rnd, true);
                }
                this.trySpawnZombieIgnoringDaylight(level, player, rnd);
            }
        }
    }

    private void trySpawnHostileNear(ServerLevel level, ServerPlayer player, RandomSource rnd, boolean requireDarkness) {
        int pick;
        Object mob;
        BlockPos pos = this.randomSurfacePosAround(level, player.blockPosition(), rnd);
        if (pos == null) {
            return;
        }
        if (level.getDifficulty().getId() == 0) {
            return;
        }
        if (!level.isLoaded(pos)) {
            return;
        }
        if (!level.getWorldBorder().isWithinBounds(pos)) {
            return;
        }
        if (requireDarkness) {
            int sky = level.getBrightness(LightLayer.SKY, pos);
            int block = level.getBrightness(LightLayer.BLOCK, pos);
            if (sky > 7 || block > 7) {
                return;
            }
        }
        if ((mob = (pick = rnd.nextInt(3)) == 0 ? new Zombie(EntityType.ZOMBIE, (Level)level) : (pick == 1 ? new Spider(EntityType.SPIDER, (Level)level) : new Creeper(EntityType.CREEPER, (Level)level))) == null) {
            return;
        }
        this.spawnMobIfValid(level, pos, (Mob)mob, true);
    }

    private void trySpawnZombieIgnoringDaylight(ServerLevel level, ServerPlayer player, RandomSource rnd) {
        BlockPos pos = this.randomSurfacePosAround(level, player.blockPosition(), rnd);
        if (pos == null) {
            return;
        }
        if (level.getDifficulty().getId() == 0) {
            return;
        }
        if (!level.isLoaded(pos)) {
            return;
        }
        if (!level.getWorldBorder().isWithinBounds(pos)) {
            return;
        }
        Zombie zombie = new Zombie(EntityType.ZOMBIE, (Level)level);
        if (zombie == null) {
            return;
        }
        this.spawnMobIfValid(level, pos, (Mob)zombie, false);
    }

    private void spawnMobIfValid(ServerLevel level, BlockPos pos, Mob mob, boolean checkVanillaRules) {
        mob.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        if (!level.noCollision((Entity)mob)) {
            return;
        }
        if (checkVanillaRules) {
            try {
                if (!SpawnPlacements.isSpawnPositionOk((EntityType)mob.getType(), (LevelReader)level, (BlockPos)pos)) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        level.addFreshEntity((Entity)mob);
    }

    private BlockPos randomSurfacePosAround(ServerLevel level, BlockPos center, RandomSource rnd) {
        for (int tries = 0; tries < 12; ++tries) {
            int dz;
            double angle = rnd.nextDouble() * Math.PI * 2.0;
            double dist = Mth.nextDouble((RandomSource)rnd, (double)24.0, (double)48.0);
            int dx = (int)Math.round(Math.cos(angle) * dist);
            BlockPos base = center.offset(dx, 0, dz = (int)Math.round(Math.sin(angle) * dist));
            BlockPos top = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base);
            BlockPos pos = this.findStandableOnTop(level, top);
            if (pos == null) continue;
            return pos;
        }
        return null;
    }

    private BlockPos findStandableOnTop(ServerLevel level, BlockPos start) {
        BlockPos.MutableBlockPos cur = new BlockPos.MutableBlockPos(start.getX(), start.getY(), start.getZ());
        for (int i = 0; i < 16; ++i) {
            BlockState below = level.getBlockState(cur.below());
            BlockState at = level.getBlockState((BlockPos)cur);
            if (below.isSolid() && at.getCollisionShape((BlockGetter)level, (BlockPos)cur).isEmpty()) {
                return cur.immutable();
            }
            cur.move(Direction.DOWN);
        }
        return null;
    }
}

