/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class Logic26 {
    private static final String NBT_KEY = "complicatedminecraftmod_health_penalty";
    private static int tickCounter = 0;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic26());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onLevelLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        this.enforceNoNaturalRegen(level.getServer());
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        if (tickCounter++ % 100 == 0) {
            this.enforceNoNaturalRegen(server);
        }
    }

    private void enforceNoNaturalRegen(MinecraftServer server) {
        if (server == null) {
            return;
        }
        try {
            ((GameRules.BooleanValue)server.getGameRules().getRule(GameRules.RULE_NATURAL_REGENERATION)).set(false, server);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        boolean allow = false;
        MobEffectInstance regen = player.getEffect(MobEffects.REGENERATION);
        MobEffectInstance instant = player.getEffect(MobEffects.INSTANT_HEALTH);
        if (regen != null && !regen.isAmbient()) {
            allow = true;
        }
        if (instant != null && !instant.isAmbient()) {
            allow = true;
        }
        if (!allow) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag tag = player.getPersistentData();
        int penalty = tag.getInt(NBT_KEY).orElse(0);
        penalty = Math.max(0, penalty + 1);
        tag.putInt(NBT_KEY, penalty);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player p = event.getEntity();
        CompoundTag ptag = p.getPersistentData();
        int penalty = ptag.getInt(NBT_KEY).orElse(0);
        this.applyPenaltyToAttributes(p, penalty);
        if (p.getHealth() > p.getMaxHealth()) {
            p.setHealth(p.getMaxHealth());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        Player newPlayer = event.getEntity();
        CompoundTag orig = original.getPersistentData();
        int penalty = orig.getInt(NBT_KEY).orElse(0);
        newPlayer.getPersistentData().putInt(NBT_KEY, penalty);
        this.applyPenaltyToAttributes(newPlayer, penalty);
        newPlayer.setHealth(newPlayer.getMaxHealth());
    }

    @SubscribeEvent
    public void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.getItem().is(Items.GOLDEN_APPLE) || event.getItem().is(Items.ENCHANTED_GOLDEN_APPLE)) {
            player.getPersistentData().putInt(NBT_KEY, 0);
            this.applyPenaltyToAttributes(player, 0);
            player.setHealth(player.getMaxHealth());
        }
    }

    private void applyPenaltyToAttributes(Player player, int penalty) {
        try {
            double base = 20.0 - (double)penalty * 2.0;
            base = Math.max(2.0, base);
            AttributeInstance inst = player.getAttribute(Attributes.MAX_HEALTH);
            if (inst != null) {
                inst.setBaseValue(base);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

