/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class Logic27 {
    private static final double DETECTION_RANGE = 150.0;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic27());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        if (!(mob instanceof Enemy)) {
            return;
        }
        if (mob.level().isClientSide()) {
            return;
        }
        Level level = mob.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (mob.tickCount % 10 != 0) {
            return;
        }
        TargetingConditions conditions = TargetingConditions.forCombat().range(150.0).ignoreLineOfSight().ignoreInvisibilityTesting();
        Player nearest = serverLevel.getNearestPlayer(conditions, (LivingEntity)mob);
        if (nearest == null) {
            return;
        }
        if (nearest.isCreative() || nearest.isSpectator()) {
            return;
        }
        mob.setTarget((LivingEntity)nearest);
    }
}

