/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class Logic29 {
    private static final double EXTENDED_REACH = 5.0;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic29());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof IronGolem)) {
            return;
        }
        IronGolem golem = (IronGolem)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        this.tryApplyMultiplier((LivingEntity)golem, (Holder<Attribute>)Attributes.MAX_HEALTH, 3.0);
        golem.setHealth(golem.getMaxHealth());
        this.tryApplyMultiplier((LivingEntity)golem, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, 1.0);
        this.ensureSpeedEffect((LivingEntity)golem);
    }

    @SubscribeEvent
    public void onEntityTick(EntityTickEvent.Post event) {
        double reachSq;
        double distSq;
        Player player;
        LivingEntity target;
        Player nearest;
        Entity entity = event.getEntity();
        if (!(entity instanceof IronGolem)) {
            return;
        }
        IronGolem golem = (IronGolem)entity;
        if (golem.level().isClientSide()) {
            return;
        }
        Level level = golem.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (golem.tickCount % 40 == 0) {
            this.ensureSpeedEffect((LivingEntity)golem);
        }
        if (golem.tickCount % 10 == 0 && (nearest = serverLevel.getNearestPlayer((Entity)golem, 150.0)) != null && !nearest.isCreative() && !nearest.isSpectator()) {
            golem.setTarget((LivingEntity)nearest);
        }
        if ((target = golem.getTarget()) instanceof Player && !(player = (Player)target).isCreative() && !player.isSpectator() && (distSq = golem.distanceToSqr((Entity)player)) <= (reachSq = 25.0) && golem.tickCount % 10 == 0) {
            golem.swing(InteractionHand.MAIN_HAND);
            golem.doHurtTarget(serverLevel, (Entity)player);
        }
    }

    private void tryApplyMultiplier(LivingEntity entity, Holder<Attribute> attribute, double multiplier) {
        try {
            double base;
            AttributeInstance inst = entity.getAttribute(attribute);
            if (inst != null && (base = inst.getBaseValue()) > 0.0) {
                inst.setBaseValue(base * multiplier);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void ensureSpeedEffect(LivingEntity entity) {
        try {
            entity.addEffect(new MobEffectInstance(MobEffects.SPEED, 72000, 1, false, false, false));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

