/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;

public class Logic3 {
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic3());
    }

    public static void run(ServerPlayer player) {
        active = true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player == null || player.level().isClientSide) {
            return;
        }
        if (!active) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty() || !Logic3.isAnyPickaxe(stack)) {
            return;
        }
        double chance = Logic3.getBreakChanceForPickaxe(stack);
        if (chance <= 0.0) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() < chance) {
            int extraDamage = Logic3.getExtraDamageForPickaxe(stack);
            if (extraDamage > 0) {
                stack.hurtAndBreak(extraDamage, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.getInventory().setChanged();
            }
        }
    }

    private static boolean isAnyPickaxe(ItemStack stack) {
        return stack.is(Items.WOODEN_PICKAXE) || stack.is(Items.STONE_PICKAXE) || stack.is(Items.IRON_PICKAXE) || stack.is(Items.GOLDEN_PICKAXE) || stack.is(Items.DIAMOND_PICKAXE) || stack.is(Items.NETHERITE_PICKAXE);
    }

    private static double getBreakChanceForPickaxe(ItemStack stack) {
        if (stack.is(Items.WOODEN_PICKAXE)) {
            return 0.5;
        }
        if (stack.is(Items.GOLDEN_PICKAXE)) {
            return 0.35;
        }
        if (stack.is(Items.STONE_PICKAXE)) {
            return 0.2;
        }
        if (stack.is(Items.IRON_PICKAXE)) {
            return 0.1;
        }
        if (stack.is(Items.DIAMOND_PICKAXE)) {
            return 0.03;
        }
        if (stack.is(Items.NETHERITE_PICKAXE)) {
            return 0.01;
        }
        return 0.15;
    }

    private static int getExtraDamageForPickaxe(ItemStack stack) {
        if (stack.is(Items.WOODEN_PICKAXE)) {
            return 3;
        }
        if (stack.is(Items.GOLDEN_PICKAXE)) {
            return 3;
        }
        if (stack.is(Items.STONE_PICKAXE)) {
            return 2;
        }
        if (stack.is(Items.IRON_PICKAXE)) {
            return 1;
        }
        if (stack.is(Items.DIAMOND_PICKAXE)) {
            return 1;
        }
        if (stack.is(Items.NETHERITE_PICKAXE)) {
            return 1;
        }
        return 1;
    }
}

