/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class Logic31 {
    private static final String NBT_BLOCKED = "cm_block_trades";
    private static final double BLOCK_CHANCE = 0.2;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic31());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        CompoundTag tag = villager.getPersistentData();
        if (tag.getBoolean(NBT_BLOCKED).orElse(false).booleanValue()) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() < 0.2) {
            tag.putBoolean(NBT_BLOCKED, true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (villager.getPersistentData().getBoolean(NBT_BLOCKED).orElse(false).booleanValue()) {
            event.setCanceled(true);
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7This resident is not currently trading."), true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (villager.getPersistentData().getBoolean(NBT_BLOCKED).orElse(false).booleanValue()) {
            event.setCanceled(true);
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7cThis resident is not currently trading."), true);
            }
        }
    }
}

