/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class Logic35 {
    private static volatile boolean registered = false;
    private static boolean active = false;
    private static final double SPAWN_CHANCE = 0.5;

    public static void init() {
        if (registered) {
            return;
        }
        NeoForge.EVENT_BUS.register((Object)new Logic35());
        registered = true;
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (player.level().isClientSide()) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() >= 0.5) {
            return;
        }
        FishingHook hook = event.getHookEntity();
        Vec3 spawnPos = hook != null ? hook.position() : player.position();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        EntityType[] choices = new EntityType[]{EntityType.ZOMBIE, EntityType.SKELETON, EntityType.SPIDER, EntityType.CREEPER, EntityType.WITCH};
        int idx = ThreadLocalRandom.current().nextInt(choices.length);
        EntityType type = choices[idx];
        Object mob = type == EntityType.ZOMBIE ? new Zombie(EntityType.ZOMBIE, (Level)level2) : (type == EntityType.SKELETON ? new Skeleton(EntityType.SKELETON, (Level)level2) : (type == EntityType.SPIDER ? new Spider(EntityType.SPIDER, (Level)level2) : (type == EntityType.CREEPER ? new Creeper(EntityType.CREEPER, (Level)level2) : (type == EntityType.WITCH ? new Witch(EntityType.WITCH, (Level)level2) : null))));
        if (mob == null) {
            return;
        }
        mob.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        mob.setYRot(player.getYRot());
        mob.setXRot(0.0f);
        level2.addFreshEntity((Entity)mob);
        CompoundTag tag = mob.getPersistentData();
        try {
            tag.putString("cm_pull_player", player.getUUID().toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        tag.putInt("cm_pull_ticks", 20);
        try {
            if (mob instanceof Monster) {
                Monster mon = (Monster)mob;
                try {
                    mon.setAggressive(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            mob.setTarget((LivingEntity)player);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onEntityTick(EntityTickEvent.Pre event) {
        UUID uuid;
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        CompoundTag tag = mob.getPersistentData();
        int ticks = tag.getInt("cm_pull_ticks").orElse(0);
        if (ticks <= 0) {
            return;
        }
        try {
            String id = String.valueOf(tag.getString("cm_pull_player"));
            uuid = id.isEmpty() ? null : UUID.fromString(id);
        }
        catch (Throwable t) {
            uuid = null;
        }
        if (uuid == null) {
            tag.remove("cm_pull_ticks");
            tag.remove("cm_pull_player");
            return;
        }
        Player player = level2.getPlayerByUUID(uuid);
        if (player == null || !player.isAlive()) {
            tag.remove("cm_pull_ticks");
            tag.remove("cm_pull_player");
            return;
        }
        Vec3 pos = mob.position();
        Vec3 toPlayer = player.position().subtract(pos);
        double dist = toPlayer.length();
        if (dist > 1.0E-4) {
            Vec3 dir = toPlayer.scale(1.0 / dist);
            double strength = 0.1 + Math.min(0.2, dist * 0.03);
            double upBias = 0.04;
            Vec3 delta = mob.getDeltaMovement().add(dir.scale(strength)).add(0.0, upBias, 0.0);
            mob.setDeltaMovement(delta);
            mob.setYRot((float)(Math.atan2(-dir.x, dir.z) * 57.29577951308232));
        }
        if (--ticks <= 0) {
            tag.remove("cm_pull_ticks");
            tag.remove("cm_pull_player");
        } else {
            tag.putInt("cm_pull_ticks", ticks);
        }
    }
}

