/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic39 {
    private static final double MOVE_EPS = 0.05;
    private static final long IDLE_THRESHOLD_TICKS = 200L;
    private static final long DAMAGE_INTERVAL_TICKS = 20L;
    private static final Map<UUID, Vec3> LAST_POS = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Long> LAST_MOVE_TICK = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> LAST_DAMAGE_TICK = new HashMap<UUID, Long>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic39());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        long lastDmg;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        if (player.isSpectator() || player.isCreative()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        long now = level.getGameTime();
        UUID id = player.getUUID();
        Vec3 pos = player.position();
        Vec3 prev = LAST_POS.get(id);
        boolean moved = false;
        if (prev == null) {
            LAST_POS.put(id, pos);
            LAST_MOVE_TICK.put(id, now);
            return;
        }
        double dist = pos.distanceTo(prev);
        double vel2 = player.getDeltaMovement().lengthSqr();
        if (dist > 0.05 || vel2 > 0.0025000000000000005) {
            moved = true;
        }
        if (moved) {
            LAST_POS.put(id, pos);
            LAST_MOVE_TICK.put(id, now);
            LAST_DAMAGE_TICK.remove(id);
            return;
        }
        long lastMove = LAST_MOVE_TICK.getOrDefault(id, now);
        long idleTicks = now - lastMove;
        if (idleTicks >= 200L && now - (lastDmg = LAST_DAMAGE_TICK.getOrDefault(id, 0L).longValue()) >= 20L) {
            player.hurt(player.damageSources().generic(), 1.0f);
            LAST_DAMAGE_TICK.put(id, now);
        }
    }
}

