/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic42 {
    private static boolean registered = false;
    private static boolean active = true;
    private static final long DAMAGE_INTERVAL_TICKS = 10L;
    private static final Map<UUID, Long> LAST_DAMAGE_TICK = new HashMap<UUID, Long>();

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic42());
    }

    public static void run(ServerPlayer player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        UUID id;
        long last;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        if (!active) {
            return;
        }
        if (player.isSpectator() || player.isCreative()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        if (!Logic42.isPlayerUnderRain(level, player)) {
            return;
        }
        long now = level.getGameTime();
        if (now - (last = LAST_DAMAGE_TICK.getOrDefault(id = player.getUUID(), 0L).longValue()) >= 10L) {
            player.hurt(player.damageSources().generic(), 1.0f);
            LAST_DAMAGE_TICK.put(id, now);
        }
    }

    @SubscribeEvent
    public void onEntityTick(EntityTickEvent.Post event) {
        UUID id;
        long last;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2.level().isClientSide()) {
            return;
        }
        if (!active) {
            return;
        }
        if (entity2 instanceof Player) {
            return;
        }
        ServerLevel level = (ServerLevel)entity2.level();
        if (!Logic42.isEntityUnderRain(level, entity2)) {
            return;
        }
        long now = level.getGameTime();
        if (now - (last = LAST_DAMAGE_TICK.getOrDefault(id = entity2.getUUID(), 0L).longValue()) >= 10L) {
            entity2.hurt(entity2.damageSources().generic(), 1.0f);
            LAST_DAMAGE_TICK.put(id, now);
        }
    }

    private static boolean isPlayerUnderRain(ServerLevel level, Player player) {
        if (!level.isRaining()) {
            return false;
        }
        BlockPos pos = player.blockPosition();
        return level.isRainingAt(pos) || level.isRainingAt(pos.above());
    }

    private static boolean isEntityUnderRain(ServerLevel level, LivingEntity entity) {
        if (!level.isRaining()) {
            return false;
        }
        BlockPos pos = entity.blockPosition();
        return level.isRainingAt(pos) || level.isRainingAt(pos.above());
    }
}

