/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic45 {
    private static boolean registered = false;
    public static float toggleFrequencySeconds = 3.0f;
    private static final Map<UUID, Long> NEXT_ACTION_TICK = new HashMap<UUID, Long>();
    private static boolean active = false;

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic45());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        long next;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        UUID id = player.getUUID();
        long now = level.getGameTime();
        if (now < (next = NEXT_ACTION_TICK.getOrDefault(id, now).longValue())) {
            return;
        }
        long intervalTicks = (long)(toggleFrequencySeconds * 20.0f);
        NEXT_ACTION_TICK.put(id, now + intervalTicks);
        List<BlockPos> interactables = Logic45.findInteractablesInRadius(level, player.blockPosition(), 50, 10);
        if (interactables.isEmpty()) {
            return;
        }
        if (level.getRandom().nextFloat() < 0.95f) {
            BlockPos randomInteractable = interactables.get(level.getRandom().nextInt(interactables.size()));
            Logic45.toggleInteractable(level, randomInteractable);
        }
    }

    private static List<BlockPos> findInteractablesInRadius(ServerLevel level, BlockPos center, int radius, int yRange) {
        ArrayList<BlockPos> interactables = new ArrayList<BlockPos>();
        int minY = center.getY() - yRange;
        int maxY = center.getY() + yRange;
        for (int x = center.getX() - radius; x <= center.getX() + radius; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = center.getZ() - radius; z <= center.getZ() + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = level.getBlockState(pos).getBlock();
                    if (!(block instanceof DoorBlock) && !(block instanceof TrapDoorBlock) && !(block instanceof RedstoneLampBlock)) continue;
                    interactables.add(pos);
                    if (interactables.size() < 100) continue;
                    return interactables;
                }
            }
        }
        return interactables;
    }

    private static void toggleInteractable(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof DoorBlock) {
            DoorBlock doorBlock = (DoorBlock)block;
            boolean open = (Boolean)state.getValue((Property)DoorBlock.OPEN);
            doorBlock.setOpen(null, (Level)level, state, pos, !open);
        } else if (block instanceof TrapDoorBlock) {
            level.setBlock(pos, (BlockState)state.cycle((Property)TrapDoorBlock.OPEN), 3);
        } else if (block instanceof RedstoneLampBlock) {
            level.setBlock(pos, (BlockState)state.cycle((Property)RedstoneLampBlock.LIT), 3);
        }
    }
}

