/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Logic46 {
    private static boolean registered = false;
    private static final Map<UUID, Long> NEXT_ACTION_TICK = new HashMap<UUID, Long>();
    public static int intervalTicks = 60;
    public static float chance = 0.35f;
    private static boolean active = false;

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.register((Object)new Logic46());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        long next;
        Player p = event.getEntity();
        if (p.level().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)p.level();
        UUID id = p.getUUID();
        long now = level.getGameTime();
        if (now < (next = NEXT_ACTION_TICK.getOrDefault(id, now).longValue())) {
            return;
        }
        NEXT_ACTION_TICK.put(id, now + (long)intervalTicks);
        BlockPos playerPos = p.blockPosition();
        if (!Logic46.isDark((Level)level, playerPos)) {
            return;
        }
        if (level.getRandom().nextFloat() > chance) {
            return;
        }
        int radius = 10;
        int tries = 40;
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        for (int i = 0; i < 40; ++i) {
            BlockState torchState;
            int dx = rng.nextInt(-10, 11);
            int dz = rng.nextInt(-10, 11);
            int dy = rng.nextInt(-2, 3);
            BlockPos pos = playerPos.offset(dx, dy, dz);
            if (!level.isEmptyBlock(pos) || !(torchState = Blocks.TORCH.defaultBlockState()).canSurvive((LevelReader)level, pos) || !Logic46.isDark((Level)level, pos) || !level.setBlock(pos, torchState, 3)) continue;
            level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 0.8f, 1.2f);
            break;
        }
    }

    private static boolean isDark(Level level, BlockPos pos) {
        return level.getMaxLocalRawBrightness(pos) <= 7;
    }
}

