/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.EnumSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class Logic5 {
    private static boolean active = false;
    private static boolean registered = false;
    private static int scanTicker = 0;

    public static void init() {
        if (registered) {
            return;
        }
        registered = true;
        NeoForge.EVENT_BUS.addListener(Logic5::onEntityJoinLevel);
        NeoForge.EVENT_BUS.addListener(Logic5::onProjectileImpact);
        NeoForge.EVENT_BUS.addListener(Logic5::onLevelTickPost);
    }

    public static int run(ServerPlayer player) {
        active = true;
        return 1;
    }

    private static void onLevelTickPost(LevelTickEvent.Post event) {
        if (!active) {
            return;
        }
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (scanTicker++ % 40 != 0) {
            return;
        }
        AABB bounds = new AABB(-3.0E7, -3.0E7, -3.0E7, 3.0E7, 3.0E7, 3.0E7);
        for (Ghast ghast : level.getEntitiesOfClass(Ghast.class, bounds)) {
            if (ghast.getTags().contains("logic5_goal_added")) continue;
            ghast.goalSelector.getAvailableGoals().removeIf(wrapped -> wrapped.getGoal().getClass().getName().contains("GhastShootFireballGoal"));
            ghast.goalSelector.addGoal(4, (Goal)new GhastFastShootGoal(ghast));
            ghast.addTag("logic5_goal_added");
        }
    }

    private static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (!active) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Ghast)) {
            return;
        }
        Ghast ghast = (Ghast)entity;
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        if (ghast.getTags().contains("logic5_goal_added")) {
            return;
        }
        ghast.goalSelector.getAvailableGoals().removeIf(wrapped -> wrapped.getGoal().getClass().getName().contains("GhastShootFireballGoal"));
        ghast.goalSelector.addGoal(4, (Goal)new GhastFastShootGoal(ghast));
        ghast.addTag("logic5_goal_added");
    }

    private static void onProjectileImpact(ProjectileImpactEvent event) {
        if (!active) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof LargeFireball)) {
            return;
        }
        LargeFireball fireball = (LargeFireball)projectile;
        if (!(fireball.getOwner() instanceof Ghast)) {
            return;
        }
        HitResult hit = event.getRayTraceResult();
        if (hit.getType() == HitResult.Type.MISS) {
            return;
        }
        Level level = fireball.level();
        if (level.isClientSide()) {
            return;
        }
        event.setCanceled(true);
        fireball.discard();
        float power = 3.0f;
        level.explode(null, fireball.getX(), fireball.getY(), fireball.getZ(), power, Level.ExplosionInteraction.NONE);
    }

    private static class GhastFastShootGoal
    extends Goal {
        private final Ghast ghast;
        private int cooldown;
        private int chargeTime;

        GhastFastShootGoal(Ghast ghast) {
            this.ghast = ghast;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.cooldown = 0;
            this.chargeTime = 0;
        }

        public boolean canUse() {
            return this.ghast.getTarget() != null;
        }

        public boolean canContinueToUse() {
            return this.ghast.getTarget() != null;
        }

        public void start() {
            this.cooldown = 0;
        }

        public void tick() {
            LivingEntity target = this.ghast.getTarget();
            if (target == null) {
                return;
            }
            double dx = target.getX() - this.ghast.getX();
            double dy = target.getEyeY() - this.ghast.getEyeY();
            double dz = target.getZ() - this.ghast.getZ();
            double distSq = dx * dx + dy * dy + dz * dz;
            this.ghast.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            if (this.ghast.hasLineOfSight((Entity)target) && distSq < 1000.0) {
                Level level = this.ghast.level();
                this.ghast.setCharging(true);
                if (this.chargeTime == 0) {
                    level.playSound(null, (Entity)this.ghast, SoundEvents.GHAST_WARN, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                ++this.chargeTime;
                if (this.chargeTime >= 4) {
                    if (!level.isClientSide()) {
                        Vec3 dir = new Vec3(dx, dy, dz).normalize().scale(0.5);
                        LargeFireball fireball = new LargeFireball(level, (LivingEntity)this.ghast, dir, 1);
                        fireball.setPos(this.ghast.getX(), this.ghast.getEyeY() - 0.2, this.ghast.getZ());
                        fireball.setDeltaMovement(dir);
                        level.addFreshEntity((Entity)fireball);
                    }
                    level.playSound(null, (Entity)this.ghast, SoundEvents.GHAST_SHOOT, SoundSource.HOSTILE, 1.0f, 1.0f);
                    this.chargeTime = 0;
                    this.ghast.setCharging(false);
                    this.cooldown = 8;
                }
            } else if (this.chargeTime > 0) {
                this.chargeTime = 0;
                this.ghast.setCharging(false);
            }
        }
    }
}

