/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;

public class Logic50 {
    private static boolean registered = false;
    private static final double CRAFT_RADIUS = 5.0;
    private static final long CRAFT_COOLDOWN_TICKS = 40L;
    private static final Map<ServerLevel, Map<BlockPos, Long>> RECENT_CRAFTS = new HashMap<ServerLevel, Map<BlockPos, Long>>();
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic50());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity spawned = (ItemEntity)entity;
        if (event.getLevel().isClientSide()) {
            return;
        }
        this.tryCraftAt(spawned);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        ItemEntity dropped = event.getEntity();
        if (dropped != null) {
            this.tryCraftAt(dropped);
        }
    }

    private void tryCraftAt(ItemEntity center) {
        ItemStack spawnedStack = center.getItem();
        if (spawnedStack.is(Items.ENCHANTED_GOLDEN_APPLE)) {
            return;
        }
        Level level = center.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        BlockPos keyPos = center.blockPosition();
        long gameTime = sl.getGameTime();
        Map levelMap = RECENT_CRAFTS.computeIfAbsent(sl, k -> new HashMap());
        Long last = (Long)levelMap.get(keyPos);
        if (last != null && gameTime - last < 40L) {
            return;
        }
        double r = 5.0;
        AABB box = new AABB(center.getX() - r, center.getY() - r, center.getZ() - r, center.getX() + r, center.getY() + r, center.getZ() + r);
        int goldBlocks = 0;
        int goldenApples = 0;
        List candidates = level.getEntitiesOfClass(ItemEntity.class, box);
        candidates.sort(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)center)));
        for (ItemEntity ie : candidates) {
            ItemStack st = ie.getItem();
            if (st.is(Items.GOLD_BLOCK)) {
                goldBlocks += st.getCount();
                continue;
            }
            if (!st.is(Items.GOLDEN_APPLE)) continue;
            goldenApples += st.getCount();
        }
        if (goldBlocks < 3 || goldenApples < 1) {
            return;
        }
        int needGold = 3;
        int needApple = 1;
        for (ItemEntity ie : candidates) {
            int take;
            if (needGold == 0 && needApple == 0) break;
            ItemStack st = ie.getItem();
            if (st.is(Items.GOLD_BLOCK) && needGold > 0) {
                take = Math.min(needGold, st.getCount());
                st.shrink(take);
                needGold -= take;
                if (st.getCount() <= 0) {
                    ie.discard();
                    continue;
                }
                ie.setItem(st);
                continue;
            }
            if (!st.is(Items.GOLDEN_APPLE) || needApple <= 0) continue;
            take = Math.min(needApple, st.getCount());
            st.shrink(take);
            needApple -= take;
            if (st.getCount() <= 0) {
                ie.discard();
                continue;
            }
            ie.setItem(st);
        }
        if (needGold > 0 || needApple > 0) {
            return;
        }
        ItemEntity result = new ItemEntity(level, center.getX(), center.getY(), center.getZ(), new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE));
        level.addFreshEntity((Entity)result);
        level.playSound(null, center.getX(), center.getY(), center.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        levelMap.put(keyPos, gameTime);
        double px = center.getX();
        double py = center.getY() + 0.5;
        double pz = center.getZ();
        sl.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, px, py, pz, 40, 0.6, 0.6, 0.6, 0.2);
        sl.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, px, py, pz, 8, 0.4, 0.4, 0.4, 0.01);
    }
}

