/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class Logic7 {
    private static final int SEARCH_RADIUS = 10;
    private static final int CHECK_INTERVAL = 30;
    private static boolean active = false;

    public static void init() {
        NeoForge.EVENT_BUS.register((Object)new Logic7());
    }

    public static void run(Player player) {
        active = true;
    }

    @SubscribeEvent
    public void onLevelTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.isClientSide()) {
            return;
        }
        if (serverLevel.getGameTime() % 30L != 0L) {
            return;
        }
        for (Player player : serverLevel.players()) {
            AABB area = new AABB(player.getX() - 10.0, player.getY() - 10.0, player.getZ() - 10.0, player.getX() + 10.0, player.getY() + 10.0, player.getZ() + 10.0);
            List zombies = serverLevel.getEntitiesOfClass(Zombie.class, area);
            for (Zombie zombie : zombies) {
                double heightDiff;
                if (zombie.getTarget() != player || (heightDiff = player.getY() - zombie.getY()) <= 1.5) continue;
                Logic7.tryPlaceBlockUnderZombie(zombie, serverLevel);
            }
        }
    }

    private static void tryPlaceBlockUnderZombie(Zombie zombie, ServerLevel level) {
        BlockPos targetPos;
        BlockPos base = zombie.blockPosition();
        BlockPos below = base.below();
        if (level.isEmptyBlock(base)) {
            targetPos = base;
        } else if (level.isEmptyBlock(below)) {
            targetPos = below;
        } else {
            return;
        }
        BlockState toPlace = Logic7.randomClimbBlock();
        if (!level.isEmptyBlock(targetPos)) {
            return;
        }
        boolean placed = level.setBlock(targetPos, toPlace, 3);
        if (placed) {
            zombie.setPos(zombie.getX(), zombie.getY() + 1.3, zombie.getZ());
        }
    }

    private static BlockState randomClimbBlock() {
        int r = new Random().nextInt(3);
        return switch (r) {
            case 0 -> Blocks.COBBLESTONE.defaultBlockState();
            case 1 -> Blocks.OAK_PLANKS.defaultBlockState();
            default -> Blocks.STONE.defaultBlockState();
        };
    }
}

