/*
 * Decompiled with CFR 0.152.
 */
package org.example.FastBreak.complicatedminecraftmod.logic;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class PluginCommand {
    private static final String PERMISSION_LEVEL = "2";

    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"plugin").requires(source -> source.hasPermission(Integer.parseInt(PERMISSION_LEVEL)))).then(Commands.literal((String)"checking").executes(context -> {
            List<String> lines = PluginCommand.buildLogicStatusLines(51);
            if (lines.isEmpty()) {
                PluginCommand.sendErrorMessage((CommandSourceStack)context.getSource(), "There are no registered Logic scripts");
                return 0;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[\u00a7eComplicatedMinecraft\u00a7r] \u00a7fStatus Logic-scripts:\n");
            for (String line : lines) {
                sb.append(line).append("\n");
            }
            PluginCommand.sendSuccessMessage((CommandSourceStack)context.getSource(), sb.toString());
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"info").then(Commands.literal((String)"en").executes(context -> {
            List<String> lines = PluginCommand.buildInfoLinesEn();
            PluginCommand.sendPaged((CommandSourceStack)context.getSource(), "[\u00a7eComplicatedMinecraft\u00a7r] \u00a7fLogic scripts info (EN):", lines, 15);
            return 1;
        }))).then(Commands.literal((String)"ru").executes(context -> {
            List<String> lines = PluginCommand.buildInfoLinesRu();
            PluginCommand.sendPaged((CommandSourceStack)context.getSource(), "[\u00a7eComplicatedMinecraft\u00a7r] \u00a7f\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 Logic-\u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432 (RU):", lines, 15);
            return 1;
        }))));
    }

    private static int runLogic(CommandContext<CommandSourceStack> context, Consumer<ServerPlayer> logic) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            logic.accept(player);
            return 1;
        }
        PluginCommand.sendErrorMessage(source, "This command can only be used by players");
        return 0;
    }

    public static int runLogic(ServerPlayer player, Consumer<ServerPlayer> logic) {
        if (player == null) {
            return 0;
        }
        logic.accept(player);
        return 1;
    }

    private static void sendSuccessMessage(CommandSourceStack source, String message) {
        if (source != null) {
            source.sendSuccess(() -> Component.literal((String)("[\u00a7aComplicatedMinecraft\u00a7r] " + message)), true);
        }
    }

    private static void sendErrorMessage(CommandSourceStack source, String message) {
        if (source != null) {
            source.sendFailure((Component)Component.literal((String)("[\u00a7cComplicatedMinecraft\u00a7r] " + message)));
        }
    }

    private static List<String> buildLogicStatusLines(int maxIndex) {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 1; i <= maxIndex; ++i) {
            Class<?> cls = PluginCommand.getLogicClass(i);
            if (cls == null) continue;
            boolean active = PluginCommand.isLogicActive(cls);
            String color = active ? "\u00a7a" : "\u00a7c";
            String state = active ? "active" : "not active";
            lines.add(color + "Logic" + i + " \u00a77- " + state + "\u00a7r");
        }
        return lines;
    }

    private static Class<?> getLogicClass(int index) {
        String name = "org.example.FastBreak.complicatedminecraftmod.logic.Logic" + index;
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean isLogicActive(Class<?> logicClass) {
        try {
            try {
                Method m = logicClass.getDeclaredMethod("isActive", new Class[0]);
                if ((m.getModifiers() & 8) != 0 && m.getReturnType() == Boolean.TYPE) {
                    m.setAccessible(true);
                    Object res = m.invoke(null, new Object[0]);
                    if (res instanceof Boolean) {
                        Boolean b = (Boolean)res;
                        return b;
                    }
                }
            }
            catch (NoSuchMethodException m) {
                // empty catch block
            }
            try {
                Field f = logicClass.getDeclaredField("active");
                if ((f.getModifiers() & 8) != 0 && f.getType() == Boolean.TYPE) {
                    f.setAccessible(true);
                    return f.getBoolean(null);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void sendPaged(CommandSourceStack source, String header, List<String> lines, int pageSize) {
        if (lines == null || lines.isEmpty()) {
            PluginCommand.sendErrorMessage(source, "No data");
            return;
        }
        int total = lines.size();
        int page = 0;
        for (int i = 0; i < total; i += pageSize) {
            int end = Math.min(total, i + pageSize);
            StringBuilder sb = new StringBuilder();
            if (page == 0) {
                sb.append(header).append("\n");
            } else {
                sb.append(header).append(" (cont.)\n");
            }
            for (int j = i; j < end; ++j) {
                sb.append(lines.get(j)).append("\n");
            }
            PluginCommand.sendSuccessMessage(source, sb.toString());
            ++page;
        }
    }

    private static List<String> buildInfoLinesEn() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("\u00a7bLogic1\u00a7r - Zombies deal 5x damage to players.");
        lines.add("\u00a7bLogic2\u00a7r - Zombies/Skeletons don't burn; spiders aggressively retarget the nearest player.");
        lines.add("\u00a7bLogic3\u00a7r - Pickaxes can take extra durability damage when mining; cheaper tools suffer more.");
        lines.add("\u00a7bLogic4\u00a7r - Arrows have a chance to explode on hitting a living entity.");
        lines.add("\u00a7bLogic5\u00a7r - Ghasts shoot much faster; their fireball explosions are stronger.");
        lines.add("\u00a7bLogic6\u00a7r - Zombies stuck near players break blocks in their path to reach them.");
        lines.add("\u00a7bLogic7\u00a7r - Zombies place blocks under themselves to climb up toward players.");
        lines.add("\u00a7bLogic8\u00a7r - Zombies may spawn with random permanent potion effects.");
        lines.add("\u00a7bLogic9\u00a7r - Some zombies spawn with a random sword and a random subset of armor.");
        lines.add("\u00a7bLogic10\u00a7r - Fire needs 5 left-clicks to extinguish; empty-hand clicks hurt the player.");
        lines.add("\u00a7bLogic11\u00a7r - Skeleton arrows auto-aim toward the nearest valid player mid-flight.");
        lines.add("\u00a7bLogic12\u00a7r - A portion of creepers spawn charged (via visual lightning strikes).");
        lines.add("\u00a7bLogic13\u00a7r - Chests are capped: single 9 slots, double 18; ender chest 9 slots.");
        lines.add("\u00a7bLogic14\u00a7r - When smelting completes, the furnace may explode near its position.");
        lines.add("\u00a7bLogic15\u00a7r - Breaking hard blocks empty-handed may deal 1.5 hearts to the player.");
        lines.add("\u00a7bLogic16\u00a7r - If spiders are nearby, periodically place a cobweb at the player's feet.");
        lines.add("\u00a7bLogic17\u00a7r - Boats ridden by players randomly break after 15\u201330 seconds.");
        lines.add("\u00a7bLogic18\u00a7r - During rain, primed TNT occasionally falls around players.");
        lines.add("\u00a7bLogic19\u00a7r - Peaceful animals flee from nearby players (wolves excluded).");
        lines.add("\u00a7bLogic20\u00a7r - Creepers periodically throw primed TNT at nearby players.");
        lines.add("\u00a7bLogic21\u00a7r - Players must sleep for 60s; time is frozen to prevent skipping until morning set.");
        lines.add("\u00a7bLogic22\u00a7r - On hard landings, create an explosion crater scaled by fall distance.");
        lines.add("\u00a7bLogic23\u00a7r - Wild wolves auto-aggro; their hits can set players on fire briefly.");
        lines.add("\u00a7bLogic24\u00a7r - Forces server difficulty to HARD and locks it.");
        lines.add("\u00a7bLogic25\u00a7r - Boost hostile spawns near players (in darkness); zombies can spawn even in daylight.");
        lines.add("\u00a7bLogic26\u00a7r - Only potions heal; each death reduces max hearts; golden apples fully restore.");
        lines.add("\u00a7bLogic27\u00a7r - Hostile mobs sense and target the nearest player up to 150 blocks, ignoring walls.");
        lines.add("\u00a7bLogic28\u00a7r - Entering a village may start a raid if none is nearby.");
        lines.add("\u00a7bLogic29\u00a7r - Iron Golems are buffed and aggressively target players with extended melee reach.");
        lines.add("\u00a7bLogic30\u00a7r - Air depletes faster underwater and regenerates slower; drowning hurts quicker.");
        lines.add("\u00a7bLogic31\u00a7r - Random villagers refuse to trade; interactions are canceled.");
        lines.add("\u00a7bLogic32\u00a7r - Hides XYZ/Block/Chunk lines from the F3 debug screen.");
        lines.add("\u00a7bLogic33\u00a7r - Generates iron-bar spawner cages; bars/stone can be broken only by explosions.");
        lines.add("\u00a7bLogic34\u00a7r - Blazes fire small fireballs at short intervals toward their target.");
        lines.add("\u00a7bLogic35\u00a7r - On successful fishing, a hostile mob may spawn near the hook and get pulled to you.");
        lines.add("\u00a7bLogic36\u00a7r - Builds a compact End platform (3x3 bedrock) and clears nearby space.");
        lines.add("\u00a7bLogic37\u00a7r - The torch goes out after 5 minutes and can be lit with flint and steel.");
        lines.add("\u00a7bLogic38\u00a7r - Locks brightness (gamma) to minimum and darkens nights further with an overlay.");
        lines.add("\u00a7bLogic39\u00a7r - If a player stands still for >10s, they take periodic damage until moving.");
        lines.add("\u00a7bLogic40\u00a7r - At night blocks can't be placed; melee works only with empty hand.");
        lines.add("\u00a7bLogic41\u00a7r - With a 10% chance, a warden may spawn next to the player at night.");
        lines.add("\u00a7bLogic42\u00a7r - If the player gets caught in the rain, he will receive damage of 0.5 health.");
        lines.add("\u00a7bLogic43\u00a7r - When eating a regular apple, there is a small chance to gain the Regeneration effect for 5 seconds. When eating an enchanted golden apple, you receive Regeneration I for 50 seconds. Maximum health is set to 40.0 HP, and with a 70% chance, Strength V is applied for 30 seconds.");
        lines.add("\u00a7bLogic44\u00a7r - When certain mobs are killed, a Vex may appear.");
        lines.add("\u00a7bLogic45\u00a7r - Every 10 seconds, doors, trapdoors, or redstone lamps within 50 blocks may randomly toggle.");
        lines.add("\u00a7bLogic46\u00a7r - If it is dark around the player, there is a small chance for an unextinguishable torch to appear.");
        lines.add("\u00a7bLogic47\u00a7r - Champions will try to break beds within the player's visible radius. If the target is unreachable, the champion switches to the player.");
        lines.add("\u00a7bLogic48\u00a7r - Explosions do not cause damage to hostile mobs.");
        lines.add("\u00a7bLogic49\u00a7r - Improved bonus chest.");
        lines.add("\u00a7bLogic50\u00a7r - You can craft an enchanted apple by throwing 3 gold blocks and 1 golden apple into a specific place.");
        lines.add("\u00a7bLogic51\u00a7r - Some tools can be enchanted by throwing an emerald into them. A maximum of three enchantments can be applied to one item.");
        return lines;
    }

    private static List<String> buildInfoLinesRu() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("\u00a7bLogic1\u00a7r - \u0417\u043e\u043c\u0431\u0438 \u043d\u0430\u043d\u043e\u0441\u044f\u0442 \u0438\u0433\u0440\u043e\u043a\u0430\u043c \u0432 5 \u0440\u0430\u0437 \u0431\u043e\u043b\u044c\u0448\u0435 \u0443\u0440\u043e\u043d\u0430.");
        lines.add("\u00a7bLogic2\u00a7r - \u0417\u043e\u043c\u0431\u0438/\u0441\u043a\u0435\u043b\u0435\u0442\u044b \u043d\u0435 \u0433\u043e\u0440\u044f\u0442; \u043f\u0430\u0443\u043a\u0438 \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u043e \u0432\u044b\u0431\u0438\u0440\u0430\u044e\u0442 \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0435\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430.");
        lines.add("\u00a7bLogic3\u00a7r - \u041a\u0438\u0440\u043a\u0438 \u043f\u043e\u043b\u0443\u0447\u0430\u044e\u0442 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0443\u0440\u043e\u043d \u043f\u0440\u043e\u0447\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0438 \u0434\u043e\u0431\u044b\u0447\u0435; \u0434\u0435\u0448\u0451\u0432\u044b\u0435 \u0441\u0442\u0440\u0430\u0434\u0430\u044e\u0442 \u0441\u0438\u043b\u044c\u043d\u0435\u0435.");
        lines.add("\u00a7bLogic4\u00a7r - \u0421\u0442\u0440\u0435\u043b\u044b \u0441 \u0448\u0430\u043d\u0441\u043e\u043c \u0432\u0437\u0440\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u043f\u0440\u0438 \u043f\u043e\u043f\u0430\u0434\u0430\u043d\u0438\u0438 \u0432 \u0436\u0438\u0432\u044b\u0445 \u0441\u0443\u0449\u0435\u0441\u0442\u0432.");
        lines.add("\u00a7bLogic5\u00a7r - \u0413\u0430\u0441\u0442\u044b \u0441\u0442\u0440\u0435\u043b\u044f\u044e\u0442 \u0433\u043e\u0440\u0430\u0437\u0434\u043e \u0447\u0430\u0449\u0435; \u0432\u0437\u0440\u044b\u0432\u044b \u0438\u0445 \u0444\u0430\u0435\u0440\u0431\u043e\u043b\u043e\u0432 \u0441\u0438\u043b\u044c\u043d\u0435\u0435.");
        lines.add("\u00a7bLogic6\u00a7r - \u0417\u043e\u043c\u0431\u0438, \u0437\u0430\u0441\u0442\u0440\u044f\u0432\u0448\u0438\u0435 \u0432\u043e\u0437\u043b\u0435 \u0438\u0433\u0440\u043e\u043a\u043e\u0432, \u043b\u043e\u043c\u0430\u044e\u0442 \u0431\u043b\u043e\u043a\u0438 \u043d\u0430 \u043f\u0443\u0442\u0438 \u043a \u043d\u0438\u043c.");
        lines.add("\u00a7bLogic7\u00a7r - \u0417\u043e\u043c\u0431\u0438 \u0441\u0442\u0430\u0432\u044f\u0442 \u0431\u043b\u043e\u043a\u0438 \u043f\u043e\u0434 \u0441\u043e\u0431\u043e\u0439, \u0447\u0442\u043e\u0431\u044b \u043f\u043e\u0434\u043d\u0438\u043c\u0430\u0442\u044c\u0441\u044f \u043a \u0438\u0433\u0440\u043e\u043a\u0430\u043c.");
        lines.add("\u00a7bLogic8\u00a7r - \u0417\u043e\u043c\u0431\u0438 \u043c\u043e\u0433\u0443\u0442 \u043f\u043e\u044f\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0441 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u043c\u0438 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u043c\u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0430\u043c\u0438.");
        lines.add("\u00a7bLogic9\u00a7r - \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0437\u043e\u043c\u0431\u0438 \u0441\u043f\u0430\u0432\u043d\u044f\u0442\u0441\u044f \u0441 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u043c \u043c\u0435\u0447\u043e\u043c \u0438 \u043d\u0430\u0431\u043e\u0440\u043e\u043c \u0431\u0440\u043e\u043d\u0438.");
        lines.add("\u00a7bLogic10\u00a7r - \u041e\u0433\u043e\u043d\u044c \u0442\u0443\u0448\u0438\u0442\u0441\u044f 5 \u043a\u043b\u0438\u043a\u0430\u043c\u0438; \u0443\u0434\u0430\u0440 \u043f\u0443\u0441\u0442\u043e\u0439 \u0440\u0443\u043a\u043e\u0439 \u043f\u043e \u043e\u0433\u043d\u044e \u043d\u0430\u043d\u043e\u0441\u0438\u0442 \u0443\u0440\u043e\u043d \u0438\u0433\u0440\u043e\u043a\u0443.");
        lines.add("\u00a7bLogic11\u00a7r - \u0421\u0442\u0440\u0435\u043b\u044b \u0441\u043a\u0435\u043b\u0435\u0442\u043e\u0432 \u0432 \u043f\u043e\u043b\u0451\u0442\u0435 \u043d\u0430\u0432\u043e\u0434\u044f\u0442\u0441\u044f \u043d\u0430 \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0435\u0433\u043e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430.");
        lines.add("\u00a7bLogic12\u00a7r - \u0427\u0430\u0441\u0442\u044c \u043a\u0440\u0438\u043f\u0435\u0440\u043e\u0432 \u043f\u043e\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0437\u0430\u0440\u044f\u0436\u0451\u043d\u043d\u044b\u043c\u0438 (\u0432\u0438\u0437\u0443\u0430\u043b\u044c\u043d\u044b\u0435 \u043c\u043e\u043b\u043d\u0438\u0438).");
        lines.add("\u00a7bLogic13\u00a7r - \u0421\u0443\u043d\u0434\u0443\u043a\u0438 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u044b: \u043e\u0434\u0438\u043d\u0430\u0440\u043d\u044b\u0435 9 \u0441\u043b\u043e\u0442\u043e\u0432, \u0434\u0432\u043e\u0439\u043d\u044b\u0435 18; \u044d\u043d\u0434\u0435\u0440-\u0441\u0443\u043d\u0434\u0443\u043a 9 \u0441\u043b\u043e\u0442\u043e\u0432.");
        lines.add("\u00a7bLogic14\u00a7r - \u041f\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438 \u043f\u0435\u0440\u0435\u043f\u043b\u0430\u0432\u043a\u0438 \u043f\u0435\u0447\u044c \u043c\u043e\u0436\u0435\u0442 \u0432\u0437\u043e\u0440\u0432\u0430\u0442\u044c\u0441\u044f \u0440\u044f\u0434\u043e\u043c \u0441 \u0441\u043e\u0431\u043e\u0439.");
        lines.add("\u00a7bLogic15\u00a7r - \u041f\u0440\u0438 \u043b\u043e\u043c\u0430\u043d\u0438\u0438 \u0442\u0432\u0451\u0440\u0434\u044b\u0445 \u0431\u043b\u043e\u043a\u043e\u0432 \u043f\u0443\u0441\u0442\u043e\u0439 \u0440\u0443\u043a\u043e\u0439 \u0435\u0441\u0442\u044c \u0448\u0430\u043d\u0441 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c 1.5 \u0441\u0435\u0440\u0434\u0446\u0430 \u0443\u0440\u043e\u043d\u0430.");
        lines.add("\u00a7bLogic16\u00a7r - \u0415\u0441\u043b\u0438 \u0440\u044f\u0434\u043e\u043c \u043f\u0430\u0443\u043a\u0438, \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438 \u0441\u0442\u0430\u0432\u0438\u0442\u0441\u044f \u043f\u0430\u0443\u0442\u0438\u043d\u0430 \u043f\u043e\u0434 \u043d\u043e\u0433\u0430\u043c\u0438 \u0438\u0433\u0440\u043e\u043a\u0430.");
        lines.add("\u00a7bLogic17\u00a7r - \u041b\u043e\u0434\u043a\u0438 \u0441 \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438 \u043b\u043e\u043c\u0430\u044e\u0442\u0441\u044f \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u043e \u0447\u0435\u0440\u0435\u0437 15\u201330 \u0441\u0435\u043a\u0443\u043d\u0434.");
        lines.add("\u00a7bLogic18\u00a7r - \u0412\u043e \u0432\u0440\u0435\u043c\u044f \u0434\u043e\u0436\u0434\u044f \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u0430\u0434\u0430\u0435\u0442 \u0437\u0430\u0436\u0436\u0451\u043d\u043d\u044b\u0439 \u0434\u0438\u043d\u0430\u043c\u0438\u0442.");
        lines.add("\u00a7bLogic19\u00a7r - \u041c\u0438\u0440\u043d\u044b\u0435 \u0436\u0438\u0432\u043e\u0442\u043d\u044b\u0435 \u0443\u0431\u0435\u0433\u0430\u044e\u0442 \u043e\u0442 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 (\u043a\u0440\u043e\u043c\u0435 \u0432\u043e\u043b\u043a\u043e\u0432).");
        lines.add("\u00a7bLogic20\u00a7r - \u041a\u0440\u0438\u043f\u0435\u0440\u044b \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438 \u0431\u0440\u043e\u0441\u0430\u044e\u0442 \u0437\u0430\u0436\u0436\u0451\u043d\u043d\u044b\u0439 \u0434\u0438\u043d\u0430\u043c\u0438\u0442 \u0432 \u0438\u0433\u0440\u043e\u043a\u043e\u0432.");
        lines.add("\u00a7bLogic21\u00a7r - \u0421\u043f\u0430\u0442\u044c \u043d\u0443\u0436\u043d\u043e 60 \u0441\u0435\u043a\u0443\u043d\u0434; \u0432\u0440\u0435\u043c\u044f \u0437\u0430\u043c\u043e\u0440\u0430\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0443\u0442\u0440\u0430.");
        lines.add("\u00a7bLogic22\u00a7r - \u041f\u0440\u0438 \u0441\u0438\u043b\u044c\u043d\u043e\u043c \u043f\u0430\u0434\u0435\u043d\u0438\u0438 \u0441\u043e\u0437\u0434\u0430\u0451\u0442\u0441\u044f \u0432\u043e\u0440\u043e\u043d\u043a\u0430-\u0432\u0437\u0440\u044b\u0432, \u0441\u0438\u043b\u0430 \u0440\u0430\u0441\u0442\u0451\u0442 \u0441 \u0432\u044b\u0441\u043e\u0442\u043e\u0439 \u043f\u0430\u0434\u0435\u043d\u0438\u044f.");
        lines.add("\u00a7bLogic23\u00a7r - \u0414\u0438\u043a\u0438\u0435 \u0432\u043e\u043b\u043a\u0438 \u0441\u0440\u0430\u0437\u0443 \u0430\u0433\u0440\u044f\u0442\u0441\u044f; \u0438\u0445 \u0443\u043a\u0443\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u043f\u043e\u0434\u0436\u0438\u0433\u0430\u0442\u044c \u0438\u0433\u0440\u043e\u043a\u0430 \u043d\u0430 \u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f.");
        lines.add("\u00a7bLogic24\u00a7r - \u041f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0441\u043b\u043e\u0436\u043d\u043e\u0441\u0442\u044c HARD \u0438 \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u0442 \u0435\u0451 \u0441\u043c\u0435\u043d\u0443.");
        lines.add("\u00a7bLogic25\u00a7r - \u0423\u0441\u0438\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u043f\u0430\u0432\u043d \u0432\u0440\u0430\u0433\u043e\u0432 \u0432 \u0442\u0435\u043c\u043d\u043e\u0442\u0435 \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438; \u0437\u043e\u043c\u0431\u0438 \u043c\u043e\u0433\u0443\u0442 \u043f\u043e\u044f\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0438 \u0434\u043d\u0451\u043c.");
        lines.add("\u00a7bLogic26\u00a7r - \u041b\u0435\u0447\u0430\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0435\u043b\u044c\u044f; \u0441\u043c\u0435\u0440\u0442\u044c \u0443\u043c\u0435\u043d\u044c\u0448\u0430\u0435\u0442 \u043c\u0430\u043a\u0441. \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u0435; \u0437\u043e\u043b\u043e\u0442\u043e\u0435 \u044f\u0431\u043b\u043e\u043a\u043e \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442.");
        lines.add("\u00a7bLogic27\u00a7r - \u0412\u0440\u0430\u0436\u0434\u0435\u0431\u043d\u044b\u0435 \u043c\u043e\u0431\u044b \u0447\u0443\u044e\u0442 \u0438 \u0431\u0435\u0440\u0443\u0442 \u0446\u0435\u043b\u044c\u044e \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0435\u0433\u043e \u0438\u0433\u0440\u043e\u043a\u0430 \u0434\u043e 150 \u0431\u043b\u043e\u043a\u043e\u0432, \u0441\u043a\u0432\u043e\u0437\u044c \u0441\u0442\u0435\u043d\u044b.");
        lines.add("\u00a7bLogic28\u00a7r - \u041f\u0440\u0438 \u0432\u0445\u043e\u0434\u0435 \u0432 \u0434\u0435\u0440\u0435\u0432\u043d\u044e \u043c\u043e\u0436\u0435\u0442 \u043d\u0430\u0447\u0430\u0442\u044c\u0441\u044f \u0440\u0435\u0439\u0434, \u0435\u0441\u043b\u0438 \u0440\u044f\u0434\u043e\u043c \u0435\u0433\u043e \u043d\u0435\u0442.");
        lines.add("\u00a7bLogic29\u00a7r - \u0416\u0435\u043b\u0435\u0437\u043d\u044b\u0435 \u0433\u043e\u043b\u0435\u043c\u044b \u0443\u0441\u0438\u043b\u0435\u043d\u044b \u0438 \u0430\u0433\u0440\u0435\u0441\u0441\u0438\u0432\u043d\u043e \u0430\u0442\u0430\u043a\u0443\u044e\u0442 \u0438\u0433\u0440\u043e\u043a\u043e\u0432 \u0441 \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u043d\u043e\u0439 \u0434\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c\u044e \u0443\u0434\u0430\u0440\u0430.");
        lines.add("\u00a7bLogic30\u00a7r - \u0412\u043e\u0437\u0434\u0443\u0445 \u043f\u043e\u0434 \u0432\u043e\u0434\u043e\u0439 \u0442\u0440\u0430\u0442\u0438\u0442\u0441\u044f \u0431\u044b\u0441\u0442\u0440\u0435\u0435, \u043d\u0430 \u0441\u0443\u0448\u0435 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043c\u0435\u0434\u043b\u0435\u043d\u043d\u0435\u0435; \u0443\u0434\u0443\u0448\u044c\u0435 \u0431\u044b\u0441\u0442\u0440\u0435\u0435.");
        lines.add("\u00a7bLogic31\u00a7r - \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0436\u0438\u0442\u0435\u043b\u0438 \u043e\u0442\u043a\u0430\u0437\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u0440\u0433\u043e\u0432\u0430\u0442\u044c; \u0432\u0437\u0430\u0438\u043c\u043e\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043e\u0442\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f.");
        lines.add("\u00a7bLogic32\u00a7r - \u0421\u043a\u0440\u044b\u0432\u0430\u0435\u0442 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b XYZ/Block/Chunk \u0432 \u044d\u043a\u0440\u0430\u043d\u0435 \u043e\u0442\u043b\u0430\u0434\u043a\u0438 (F3).");
        lines.add("\u00a7bLogic33\u00a7r - \u041f\u043e\u0440\u043e\u0436\u0434\u0430\u0435\u0442 \u043a\u043b\u0435\u0442\u043a\u0438 \u0438\u0437 \u0440\u0435\u0448\u0451\u0442\u043e\u043a \u0441\u043e \u0441\u043f\u0430\u0432\u043d\u0435\u0440\u043e\u043c; \u0441\u043b\u043e\u043c\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0437\u0440\u044b\u0432\u0430\u043c\u0438.");
        lines.add("\u00a7bLogic34\u00a7r - \u0418\u0444\u0440\u0438\u0442\u044b \u0447\u0430\u0441\u0442\u043e \u0441\u0442\u0440\u0435\u043b\u044f\u044e\u0442 \u043c\u0430\u043b\u0435\u043d\u044c\u043a\u0438\u043c\u0438 \u0444\u0430\u0435\u0440\u0431\u043e\u043b\u0430\u043c\u0438 \u043f\u043e \u0446\u0435\u043b\u0438.");
        lines.add("\u00a7bLogic35\u00a7r - \u041f\u0440\u0438 \u0443\u0434\u0430\u0447\u043d\u043e\u0439 \u0440\u044b\u0431\u0430\u043b\u043a\u0435 \u043c\u043e\u0436\u0435\u0442 \u0437\u0430\u0441\u043f\u0430\u0432\u043d\u0438\u0442\u044c\u0441\u044f \u0432\u0440\u0430\u0433 \u0443 \u043f\u043e\u043f\u043b\u0430\u0432\u043a\u0430 \u0438 \u043f\u0440\u0438\u0442\u044f\u0433\u0438\u0432\u0430\u0442\u044c\u0441\u044f \u043a \u0438\u0433\u0440\u043e\u043a\u0443.");
        lines.add("\u00a7bLogic36\u00a7r - \u0421\u0442\u0440\u043e\u0438\u0442 \u043a\u043e\u043c\u043f\u0430\u043a\u0442\u043d\u0443\u044e \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0443 \u0432 \u042d\u043d\u0434\u0435 (3x3 \u0431\u0435\u0434\u0440\u043e\u043a) \u0438 \u043e\u0447\u0438\u0449\u0430\u0435\u0442 \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u043e.");
        lines.add("\u00a7bLogic37\u00a7r - \u0424\u0430\u043a\u0435\u043b \u0433\u0430\u0441\u043d\u0435\u0442 \u0447\u0435\u0440\u0435\u0437 5 \u043c\u0438\u043d\u0443\u0442, \u0435\u0433\u043e \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0436\u0435\u0447\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043e\u0433\u043d\u0438\u0432\u0430.");
        lines.add("\u00a7bLogic38\u00a7r - \u0411\u043b\u043e\u043a\u0438\u0440\u0443\u0435\u0442 \u044f\u0440\u043a\u043e\u0441\u0442\u044c (\u0433\u0430\u043c\u043c\u0443) \u043d\u0430 \u043c\u0438\u043d\u0438\u043c\u0443\u043c\u0435 \u0438 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0437\u0430\u0442\u0435\u043c\u043d\u044f\u0435\u0442 \u043d\u043e\u0447\u044c \u043d\u0430\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c.");
        lines.add("\u00a7bLogic39\u00a7r - \u0415\u0441\u043b\u0438 \u0438\u0433\u0440\u043e\u043a \u0441\u0442\u043e\u0438\u0442 \u0431\u0435\u0437 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f >10\u0441, \u043e\u043d \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438 \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0443\u0440\u043e\u043d, \u043f\u043e\u043a\u0430 \u043d\u0435 \u0434\u0432\u0438\u043d\u0435\u0442\u0441\u044f.");
        lines.add("\u00a7bLogic40\u00a7r - \u041d\u043e\u0447\u044c\u044e \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0431\u043b\u043e\u043a\u0438; \u0431\u0438\u0442\u044c \u043c\u043e\u0431\u043e\u0432 \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0443\u0441\u0442\u043e\u0439 \u0440\u0443\u043a\u043e\u0439.");
        lines.add("\u00a7bLogic41\u00a7r - \u0421 \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c\u044e 10% \u0441\u0442\u0440\u0430\u0436 \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u044f\u0432\u0438\u0442\u044c\u0441\u044f \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u0433\u0440\u043e\u043a\u043e\u043c \u043d\u043e\u0447\u044c\u044e.");
        lines.add("\u00a7bLogic42\u00a7r - \u0415\u0441\u043b\u0438 \u0438\u0433\u0440\u043e\u043a \u043f\u043e\u043f\u0430\u0434\u0435\u0442 \u043f\u043e\u0434 \u0434\u043e\u0436\u0434\u044c, \u043e\u043d \u0431\u0443\u0434\u0435\u0442 \u043f\u043e\u043b\u0443\u0447\u0430\u0442\u044c \u0443\u0440\u043e\u043d \u043f\u043e 0,5 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044f.");
        lines.add("\u00a7bLogic43\u00a7r - \u041f\u0440\u0438 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0438 \u043e\u0431\u044b\u0447\u043d\u043e\u0433\u043e \u044f\u0431\u043b\u043e\u043a\u0430 \u0435\u0441\u0442\u044c \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u0448\u0430\u043d\u0441 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u044d\u0444\u0444\u0435\u043a\u0442 \u0440\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043d\u0430 5 \u0441\u0435\u043a\u0443\u043d\u0434. \u041f\u0440\u0438 \u0443\u043f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0438 \u0437\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0437\u043e\u043b\u043e\u0442\u043e\u0433\u043e \u044f\u0431\u043b\u043e\u043a\u0430 \u0432\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u0435 \u044d\u0444\u0444\u0435\u043a\u0442 \u0440\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 1 \u043d\u0430 50 \u0441\u0435\u043a\u0443\u043d\u0434. \u0422\u0430\u043a\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u0435 \u0432 40,0 XP., \u0438 \u0441 \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c\u044e 70% \u043d\u0430\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u044d\u0444\u0444\u0435\u043a\u0442 \u0421\u0438\u043b\u0430 V \u043d\u0430 30 \u0441\u0435\u043a\u0443\u043d\u0434.");
        lines.add("\u00a7bLogic44\u00a7r - \u041f\u0440\u0438 \u0443\u0431\u0438\u0439\u0441\u0442\u0432\u0435 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u043e\u0431\u043e\u0432 \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u044f\u0432\u0438\u0442\u044c\u0441\u044f \u0412\u0440\u0435\u0434\u0438\u043d\u0430.");
        lines.add("\u00a7bLogic45\u00a7r - \u041a\u0430\u0436\u0434\u044b\u0435 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0435\u043a\u0443\u043d\u0434 \u0434\u0432\u0435\u0440\u0438, \u043b\u044e\u043a\u0438 \u0438\u043b\u0438 \u043a\u0440\u0430\u0441\u043d\u044b\u0435 \u043a\u0430\u043c\u0435\u043d\u043d\u044b\u0435 \u043b\u0430\u043c\u043f\u044b \u0432 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u043c \u0440\u0430\u0434\u0438\u0443\u0441\u0435 \u0431\u043b\u043e\u043a\u043e\u0432 \u043c\u043e\u0433\u0443\u0442 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u043e \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u0442\u044c\u0441\u044f.");
        lines.add("\u00a7bLogic46\u00a7r - \u0415\u0441\u043b\u0438 \u0432\u043e\u043a\u0440\u0443\u0433 \u0438\u0433\u0440\u043e\u043a\u0430 \u0442\u0435\u043c\u043d\u043e, \u0435\u0441\u0442\u044c \u043d\u0435\u0431\u043e\u043b\u044c\u0448\u0430\u044f \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u043e\u0441\u0442\u044c \u0442\u043e\u0433\u043e, \u0447\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u044f\u0432\u0438\u0442\u044c\u0441\u044f \u0444\u0430\u043a\u0435\u043b, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u043f\u043e\u0433\u0430\u0441\u043d\u0435\u0442.");
        lines.add("\u00a7bLogic47\u00a7r - \u041f\u043e\u0431\u043e\u0440\u043d\u0438\u043a\u0438 \u0431\u0443\u0434\u0443\u0442 \u043f\u044b\u0442\u0430\u0442\u044c\u0441\u044f \u0441\u043b\u043e\u043c\u0430\u0442\u044c \u043a\u0440\u043e\u0432\u0430\u0442\u0438, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0438\u0435\u0441\u044f \u0432 \u0432\u0438\u0434\u0438\u043c\u043e\u043c \u0440\u0430\u0434\u0438\u0443\u0441\u0435 \u0438\u0433\u0440\u043e\u043a\u0430. \u0415\u0441\u043b\u0438 \u0446\u0435\u043b\u044c \u043d\u0435\u0434\u043e\u0441\u0442\u0438\u0436\u0438\u043c\u0430, \u043f\u043e\u0431\u043e\u0440\u043d\u0438\u043a \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u0438\u0433\u0440\u043e\u043a\u0430.");
        lines.add("\u00a7bLogic48\u00a7r - \u0412\u0437\u0440\u044b\u0432\u044b \u043d\u0435 \u043d\u0430\u043d\u043e\u0441\u044f\u0442 \u0443\u0440\u043e\u043d\u0430 \u0432\u0440\u0430\u0436\u0434\u0435\u0431\u043d\u044b\u043c \u043c\u043e\u0431\u0430\u043c.");
        lines.add("\u00a7bLogic49\u00a7r - \u0423\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u044b\u0439 \u0431\u043e\u043d\u0443\u0441\u043d\u044b\u0439 \u0441\u0443\u043d\u0434\u0443\u043a.");
        lines.add("\u00a7bLogic50\u00a7r - \u041c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0437\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u044f\u0431\u043b\u043e\u043a\u043e, \u0435\u0441\u043b\u0438 \u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0432 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e 3 \u0437\u043e\u043b\u043e\u0442\u044b\u0445 \u0431\u043b\u043e\u043a\u0430 \u0438 1 \u0437\u043e\u043b\u043e\u0442\u043e\u0435 \u044f\u0431\u043b\u043e\u043a\u043e.");
        lines.add("\u00a7bLogic51\u00a7r - \u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u044b \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u0442\u044c, \u0435\u0441\u043b\u0438 \u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0432 \u043d\u0438\u0445 \u0438\u0437\u0443\u043c\u0440\u0443\u0434. \u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u043d\u0430 \u043e\u0434\u0438\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043c\u043e\u0436\u043d\u043e \u043d\u0430\u043b\u043e\u0436\u0438\u0442\u044c \u0442\u0440\u0438 \u0437\u0430\u0447\u0430\u0440\u043e\u0432\u0430\u043d\u0438\u044f.");
        return lines;
    }
}

